/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.preference.ApplicationParametersRegistry;
import eu.geclipse.jsdl.ui.wizards.Messages;
import eu.geclipse.jsdl.ui.wizards.NewJobWizard;
import eu.geclipse.jsdl.ui.wizards.nodes.BasicWizardPart;
import eu.geclipse.jsdl.ui.wizards.nodes.SpecificWizardPart;
import eu.geclipse.jsdl.ui.wizards.specific.ApplicationSpecificPage;
import eu.geclipse.jsdl.ui.wizards.specific.IApplicationSpecificPage;
import eu.geclipse.ui.dialogs.GridFileDialog;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.widgets.StoredCombo;
import eu.geclipse.ui.wizards.IProjectSelectionProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableNewJobWizardPage
extends WizardSelectionPage
implements ModifyListener {
    private static final String STD_FILES_TOOL_TIP = "Specify executable file to activate this field";
    private static String INPUT_EXE_ID = "executable_file";
    boolean done;
    boolean firstTime = true;
    IVirtualOrganization virtualOrg;
    Text stdin;
    Text stdout;
    Text stderr;
    StoredCombo executableFile;
    Composite parentP;
    private Button gridFileDialogButton;
    private CCombo applicationName;
    private ArrayList<WizardPage> internalPages;
    private BasicWizardPart basicNode;
    private Button chooseButton;
    private Text argumentsLine;
    private Map<String, Integer> appsWithParametersFromPrefs = new HashMap<String, Integer>();
    private JSDLJobDescription basicJSDL;
    private Group stdFilesGroup;
    private Button outButton;
    private Button errButton;

    protected ExecutableNewJobWizardPage(String pageName, ArrayList<WizardPage> internalPages) {
        super(pageName);
        this.setTitle(Messages.getString("ExecutableNewJobWizardPage.title"));
        this.setDescription(Messages.getString("ExecutableNewJobWizardPage.description"));
        this.internalPages = internalPages;
    }

    public IWizardPage getNextPage() {
        block17: {
            if (this.applicationName != null && this.applicationName.getText() != null) {
                Integer aspID = this.appsWithParametersFromPrefs.get(this.applicationName.getText());
                if (aspID != null) {
                    IPath path = ApplicationParametersRegistry.getInstance().getApplicationData(aspID).getJsdlPath();
                    if (path != null && !path.toOSString().equals("")) {
                        IPath workspacePath = ((NewJobWizard)this.getWizard()).getProject();
                        workspacePath = workspacePath.append(".tempJSDL.jsdl");
                        IFile newFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(workspacePath);
                        try {
                            try {
                                newFileHandle.createLink(path, 256, null);
                                IGridElement element = GridModel.getRoot().findElement((IResource)newFileHandle);
                                if (element instanceof JSDLJobDescription) {
                                    this.basicJSDL = (JSDLJobDescription)element;
                                    ((NewJobWizard)this.getWizard()).updateBasicJSDL(this.basicJSDL, this.applicationName.getText());
                                }
                            }
                            catch (CoreException coreException) {
                                try {
                                    newFileHandle.delete(true, null);
                                }
                                catch (CoreException coreException2) {}
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                newFileHandle.delete(true, null);
                            }
                            catch (CoreException coreException) {}
                            throw throwable;
                        }
                        try {
                            newFileHandle.delete(true, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        ((NewJobWizard)this.getWizard()).updateBasicJSDL(null, this.applicationName.getText());
                    }
                }
            } else {
                ((NewJobWizard)this.getWizard()).updateBasicJSDL(null, this.applicationName.getText());
            }
        }
        return super.getNextPage();
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        this.parentP = parent;
        Composite mainComp = new Composite(parent, 0);
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        URL openFileIcon = Activator.getDefault().getBundle().getEntry("icons/obj16/open_file.gif");
        Image openFileImage = ImageDescriptor.createFromURL((URL)openFileIcon).createImage();
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.horizontalSpacing = 10;
        gLayout.verticalSpacing = 12;
        mainComp.setLayout((Layout)gLayout);
        GridData layout = new GridData();
        Label applicationNameLabel = new Label(mainComp, 36);
        applicationNameLabel.setText(Messages.getString("ExecutableNewJobWizardPage.application_name_label"));
        layout = new GridData();
        layout.horizontalAlignment = 4;
        applicationNameLabel.setLayoutData((Object)layout);
        this.applicationName = new CCombo(mainComp, 2048);
        layout = new GridData();
        layout.horizontalAlignment = 4;
        layout.horizontalSpan = 2;
        this.applicationName.setLayoutData((Object)layout);
        this.applicationName.addModifyListener((ModifyListener)this);
        this.applicationName.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ExecutableNewJobWizardPage.this.firstTime) {
                    ExecutableNewJobWizardPage.this.fetchApps(ExecutableNewJobWizardPage.this.virtualOrg);
                    ExecutableNewJobWizardPage.this.applicationName.setListVisible(true);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Label inputLabel = new Label(mainComp, 36);
        inputLabel.setText(Messages.getString("ExecutableNewJobWizardPage.exe_input_label"));
        layout = new GridData();
        layout.horizontalAlignment = 4;
        inputLabel.setLayoutData((Object)layout);
        this.executableFile = new StoredCombo(mainComp, 4);
        this.executableFile.setPreferences(prefs, INPUT_EXE_ID);
        this.executableFile.setText("");
        layout = new GridData(772);
        this.executableFile.setLayoutData((Object)layout);
        this.executableFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (ExecutableNewJobWizardPage.this.executableFile.getText().equals("")) {
                    ExecutableNewJobWizardPage.this.setStdFilesGroupEnabled(false);
                } else {
                    ExecutableNewJobWizardPage.this.setStdFilesGroupEnabled(true);
                }
            }
        });
        this.gridFileDialogButton = new Button(mainComp, 8);
        this.gridFileDialogButton.setImage(openFileImage);
        layout = new GridData(276);
        this.gridFileDialogButton.setLayoutData((Object)layout);
        this.gridFileDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridFileDialog dialog = new GridFileDialog(ExecutableNewJobWizardPage.this.getShell(), 40);
                if (dialog.open() == 0) {
                    URI[] uris = dialog.getSelectedURIs();
                    if (uris != null && uris.length > 0) {
                        ExecutableNewJobWizardPage.this.executableFile.setText(uris[0].toString());
                    } else {
                        ExecutableNewJobWizardPage.this.executableFile.setText("");
                    }
                }
            }
        });
        Label argumentsLabel = new Label(mainComp, 16384);
        argumentsLabel.setText(Messages.getString("ExecutableNewJobWizardPage.arguments_line_label"));
        layout = new GridData();
        argumentsLabel.setLayoutData((Object)layout);
        this.argumentsLine = new Text(mainComp, 2048);
        layout = new GridData(768);
        layout.horizontalSpan = 2;
        this.argumentsLine.setLayoutData((Object)layout);
        this.stdFilesGroup = new Group(mainComp, 0);
        this.stdFilesGroup.setToolTipText(STD_FILES_TOOL_TIP);
        this.stdFilesGroup.setText(Messages.getString("ExecutableNewJobWizardPage.composite_group_title"));
        this.stdFilesGroup.setLayout((Layout)new GridLayout(3, false));
        layout = new GridData(768);
        layout.grabExcessHorizontalSpace = true;
        layout.horizontalSpan = 3;
        this.stdFilesGroup.setLayoutData((Object)layout);
        Label stdinLabel = new Label((Composite)this.stdFilesGroup, 16384);
        layout = new GridData(36);
        stdinLabel.setLayoutData((Object)layout);
        stdinLabel.setText(Messages.getString("FilesInputNewJobWizardPage.stdin_label"));
        this.stdin = new Text((Composite)this.stdFilesGroup, 2048);
        layout = new GridData(836);
        this.stdin.setLayoutData((Object)layout);
        this.chooseButton = new Button((Composite)this.stdFilesGroup, 8);
        this.chooseButton.setImage(openFileImage);
        layout = new GridData(276);
        this.chooseButton.setLayoutData((Object)layout);
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI[] uris;
                GridFileDialog dialog = new GridFileDialog(ExecutableNewJobWizardPage.this.getShell(), 40);
                if (dialog.open() == 0 && (uris = ExecutableNewJobWizardPage.this.getUrisFromDialog(dialog)) != null && uris.length > 0) {
                    ExecutableNewJobWizardPage.this.stdin.setText(uris[0].toString());
                }
            }
        });
        Label stdoutLabel = new Label((Composite)this.stdFilesGroup, 0);
        layout = new GridData(36);
        stdoutLabel.setLayoutData((Object)layout);
        stdoutLabel.setText(Messages.getString("FilesInputNewJobWizardPage.stdout_label"));
        this.stdout = new Text((Composite)this.stdFilesGroup, 2048);
        layout = new GridData(836);
        this.stdout.setLayoutData((Object)layout);
        this.outButton = new Button((Composite)this.stdFilesGroup, 8);
        this.outButton.setImage(openFileImage);
        layout = new GridData(276);
        this.outButton.setLayoutData((Object)layout);
        this.outButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI[] uris;
                GridFileDialog dialog = new GridFileDialog(ExecutableNewJobWizardPage.this.getShell(), 8);
                if (dialog.open() == 0 && (uris = ExecutableNewJobWizardPage.this.getUrisFromDialog(dialog)) != null && uris.length > 0) {
                    ExecutableNewJobWizardPage.this.stdout.setText(uris[0].toString());
                }
            }
        });
        Label stderrLabel = new Label((Composite)this.stdFilesGroup, 0);
        layout = new GridData(36);
        stderrLabel.setLayoutData((Object)layout);
        stderrLabel.setText(Messages.getString("FilesInputNewJobWizardPage.stderr_label"));
        this.stderr = new Text((Composite)this.stdFilesGroup, 2048);
        layout = new GridData(836);
        this.stderr.setLayoutData((Object)layout);
        this.errButton = new Button((Composite)this.stdFilesGroup, 8);
        this.errButton.setImage(openFileImage);
        layout = new GridData(276);
        this.errButton.setLayoutData((Object)layout);
        this.errButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI[] uris;
                GridFileDialog dialog = new GridFileDialog(ExecutableNewJobWizardPage.this.getShell(), 8);
                if (dialog.open() == 0 && (uris = ExecutableNewJobWizardPage.this.getUrisFromDialog(dialog)) != null && uris.length > 0) {
                    ExecutableNewJobWizardPage.this.stderr.setText(uris[0].toString());
                }
            }
        });
        if (this.basicNode == null) {
            this.basicNode = new BasicWizardPart(this.internalPages, this.getWizard());
        }
        this.setSelectedNode(this.basicNode);
        this.setStdFilesGroupEnabled(false);
        this.setControl((Control)mainComp);
    }

    URI[] getUrisFromDialog(GridFileDialog dialog) {
        URI[] uris = dialog.getSelectedURIs();
        int j = 0;
        while (j < uris.length) {
            URI uri = uris[j];
            String query = uri.getQuery();
            if (query != null && query.trim().length() > 0) {
                String[] qParts = query.split("&");
                query = "";
                int i = 0;
                while (i < qParts.length) {
                    String qPart = qParts[i];
                    if (!qPart.startsWith("vo")) {
                        if (query.trim().length() > 0) {
                            query = String.valueOf(query) + "&";
                        }
                        query = String.valueOf(query) + qPart;
                    }
                    ++i;
                }
                if (query.trim().length() == 0) {
                    query = null;
                }
            }
            try {
                uris[j] = uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {}
            ++j;
        }
        return uris;
    }

    void fetchApps(final IVirtualOrganization vo) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block5: {
                        monitor.beginTask(Messages.getString("ExecutableNewJobWizardPage.get_apps_params_progress"), 1);
                        ExecutableNewJobWizardPage.this.firstTime = false;
                        try {
                            try {
                                ApplicationParametersRegistry.getInstance().updateApplicationsParameters(vo, monitor);
                            }
                            catch (ProblemException e) {
                                ProblemDialog.openProblem((Shell)ExecutableNewJobWizardPage.this.getShell(), (String)Messages.getString("ExecutableNewJobWizardPage.error_fetching_title"), (String)Messages.getString("ExecutableNewJobWizardPage.error_fetching_message"), (Throwable)e);
                                monitor.worked(1);
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            throw throwable;
                        }
                        monitor.worked(1);
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    Display display = workbench.getDisplay();
                    final Map<String, Integer> map = ApplicationParametersRegistry.getInstance().getApplicationDataMapping(vo);
                    display.syncExec(new Runnable(){

                        public void run() {
                            ExecutableNewJobWizardPage.this.setApplications(map);
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.logException(e);
        }
        catch (InterruptedException e) {
            Activator.logException(e);
        }
    }

    void setStdFilesGroupEnabled(boolean enabled) {
        this.stdin.setEnabled(enabled);
        this.chooseButton.setEnabled(enabled);
        this.stdout.setEnabled(enabled);
        this.outButton.setEnabled(enabled);
        this.stderr.setEnabled(enabled);
        this.errButton.setEnabled(enabled);
        if (enabled) {
            this.stdFilesGroup.setToolTipText(null);
        } else {
            this.stdFilesGroup.setToolTipText(STD_FILES_TOOL_TIP);
        }
    }

    String getSelectedElementDisplayName(IGridConnectionElement element) {
        String result = "";
        result = element.getURI().toString();
        try {
            if (element.getConnectionFileStore().getFileSystem().getScheme().equalsIgnoreCase("file")) {
                result = "file://" + result;
            }
        }
        catch (CoreException coreExc) {
            Activator.logException(coreExc);
        }
        return result;
    }

    public String getExecutableFile() {
        String result = this.executableFile.getText();
        return result;
    }

    String getApplicationName() {
        String result = this.applicationName.getText();
        if (this.appsWithParametersFromPrefs.keySet().contains(result)) {
            result = ApplicationParametersRegistry.getInstance().getApplicationData(this.appsWithParametersFromPrefs.get(result)).getApplicationName();
        }
        return result;
    }

    public void modifyText(ModifyEvent e) {
        this.getContainer().updateButtons();
        if (this.basicNode == null) {
            this.basicNode = new BasicWizardPart(this.internalPages, this.getWizard());
        }
        if (this.appsWithParametersFromPrefs.keySet().contains(this.applicationName.getText())) {
            int appId = this.appsWithParametersFromPrefs.get(this.applicationName.getText());
            IPath pathA = ApplicationParametersRegistry.getInstance().getApplicationData(appId).getXmlPath();
            Path path = new Path(pathA.toFile().getPath());
            try {
                this.setSelectedNode(new SpecificWizardPart(this.basicNode, path));
                this.executableFile.setText(ApplicationParametersRegistry.getInstance().getApplicationData(appId).getApplicationPath());
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (IOException iOException) {}
        } else {
            this.setSelectedNode(this.basicNode);
        }
    }

    public ApplicationSpecificPage getApplicationSpecificPage() {
        ApplicationSpecificPage result = null;
        return result;
    }

    protected void setSelectedNode(IWizardNode node) {
        super.setSelectedNode(node);
    }

    public List<IApplicationSpecificPage> getApplicationSpecificPages() {
        ArrayList<IApplicationSpecificPage> result = new ArrayList<IApplicationSpecificPage>();
        if (this.getSelectedNode() != null && this.getSelectedNode() != this.basicNode) {
            SpecificWizardPart specificNode = (SpecificWizardPart)this.getSelectedNode();
            IWizardPage[] iWizardPageArray = specificNode.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage asp = iWizardPageArray[n2];
                result.add((IApplicationSpecificPage)asp);
                ++n2;
            }
        }
        return result;
    }

    public String getStdin() {
        return this.stdin.getText();
    }

    public String getStdout() {
        return this.stdout.getText();
    }

    public ArrayList<String> getArgumentsList() {
        String[] table;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = table = this.argumentsLine.getText().split(" ");
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            String tableElement = stringArray[n2];
            result.add(tableElement);
            ++n2;
        }
        return result;
    }

    public JSDLJobDescription getBasicJSDL() {
        block16: {
            Integer aspID = this.appsWithParametersFromPrefs.get(this.applicationName.getText());
            if (aspID != null) {
                IPath path = ApplicationParametersRegistry.getInstance().getApplicationData(aspID).getJsdlPath();
                if (path != null && !path.toOSString().equals("")) {
                    IPath workspacePath = ((NewJobWizard)this.getWizard()).getProject();
                    workspacePath = workspacePath.append(".tempJSDL.jsdl");
                    IFile newFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(workspacePath);
                    try {
                        try {
                            newFileHandle.createLink(path, 256, null);
                            IGridElement element = GridModel.getRoot().findElement((IResource)newFileHandle);
                            if (element instanceof JSDLJobDescription) {
                                this.basicJSDL = (JSDLJobDescription)element;
                            }
                        }
                        catch (CoreException coreException) {
                            try {
                                newFileHandle.delete(true, null);
                            }
                            catch (CoreException coreException2) {}
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            newFileHandle.delete(true, null);
                        }
                        catch (CoreException coreException) {}
                        throw throwable;
                    }
                    try {
                        newFileHandle.delete(true, null);
                    }
                    catch (CoreException coreException) {}
                } else {
                    this.basicJSDL = null;
                }
            } else {
                this.basicJSDL = null;
            }
        }
        return this.basicJSDL;
    }

    public void updateButtons() {
        this.getContainer().updateButtons();
    }

    public String getStderr() {
        return this.stderr.getText();
    }

    public void setVisible(boolean visible) {
        IVirtualOrganization vo = ((IProjectSelectionProvider)this.getWizard()).getGridProject().getVO();
        if (this.virtualOrg == null || this.virtualOrg != vo) {
            this.firstTime = true;
            if (this.applicationName != null) {
                this.applicationName.removeAll();
            }
        }
        this.virtualOrg = vo;
        super.setVisible(visible);
    }

    void setApplications(Map<String, Integer> map) {
        this.appsWithParametersFromPrefs = map;
        for (String name : this.appsWithParametersFromPrefs.keySet()) {
            this.applicationName.add(name);
        }
        this.setMessage(null);
    }

    class ModifyTextListener
    implements ModifyListener {
        ModifyTextListener() {
        }

        public void modifyText(ModifyEvent event) {
            ExecutableNewJobWizardPage.this.updateButtons();
        }
    }
}

