/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescriptionModel;
import eu.geclipse.jsdl.internal.Activator;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.DocumentRoot;
import eu.geclipse.jsdl.model.posix.POSIXApplicationType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDLJobDescription
extends ResourceGridContainer
implements IGridJobDescription {
    private JSDLJobDescriptionModel internalJSDL;

    static {
        GridModel.addGridModelListener((IGridModelListener)JSDLJobDescription.createGridModelListener());
    }

    public JSDLJobDescription(IFile file) {
        super((IResource)file);
        try {
            this.internalJSDL = new JSDLJobDescriptionModel(new File(file.getLocation().toOSString()));
        }
        catch (Resource.IOWrappedException e) {
            e.printStackTrace();
        }
    }

    private static IGridModelListener createGridModelListener() {
        return new IGridModelListener(){

            public void gridModelChanged(IGridModelEvent event) {
                switch (event.getType()) {
                    case 3: {
                        IGridElement element;
                        if (event.getElements().length <= 0 || !((element = event.getElements()[0]) instanceof JSDLJobDescription)) break;
                        this.onJsdlChanged(event.getElements());
                    }
                }
            }

            private void onJsdlChanged(IGridElement[] elements) {
                IGridElement[] iGridElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement gridElement = iGridElementArray[n2];
                    if (gridElement instanceof JSDLJobDescription) {
                        JSDLJobDescription jsdlDescription = (JSDLJobDescription)gridElement;
                        try {
                            jsdlDescription.updateModelFromResource();
                        }
                        catch (Resource.IOWrappedException e) {
                            Activator.logException((Exception)((Object)e));
                        }
                    }
                    ++n2;
                }
            }
        };
    }

    void updateModelFromResource() throws Resource.IOWrappedException {
        this.internalJSDL.updateModelFromFile();
    }

    public DocumentRoot getDocumentRoot() {
        return this.internalJSDL.getDocumentRoot();
    }

    public void setRoot(DocumentRoot root) {
        this.internalJSDL.setRoot(root);
    }

    public void save() {
        this.writeModelToFile((EObject)this.internalJSDL.getDocumentRoot());
    }

    public String getJSDLString() throws IOException, CoreException {
        return this.internalJSDL.getJSDLString();
    }

    private void writeModelToFile(EObject jsdlRoot) {
        this.internalJSDL.writeModelToFile(jsdlRoot);
        try {
            this.getResource().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exc) {
            Activator.logException((Exception)((Object)exc));
        }
    }

    public void setUpBasicJSDLStructure() {
        this.internalJSDL.setUpBasicJSDLStructure();
    }

    public void setJobIdentification(String jobName, String description) {
        this.internalJSDL.setJobIdentification(jobName, description);
    }

    public void setPOSIXApplicationDetails(String applicationName, String executableFile, String stdin, String stdinName, String stdout, String outName, String err, String errName) {
        this.internalJSDL.setPOSIXApplicationDetails(applicationName, executableFile, stdin, stdinName, stdout, outName, err, errName);
    }

    public void addDataStagingOut(String name, String path) {
        this.internalJSDL.addDataStagingOut(name, path);
    }

    public void addDataStagingIn(String name, String path) {
        this.internalJSDL.addDataStagingIn(name, path);
    }

    protected POSIXApplicationType getPosixApplication() {
        return this.internalJSDL.getPosixApplication();
    }

    public String getExecutable() {
        return this.internalJSDL.getExecutable();
    }

    public String getDescription() {
        return this.internalJSDL.getDescription();
    }

    public List<String> getExecutableArguments() {
        return this.internalJSDL.getExecutableArguments();
    }

    public String getCpuArchitectureName() {
        return this.internalJSDL.getCpuArchitectureName();
    }

    public String getOSTypeName() {
        return this.internalJSDL.getOSTypeName();
    }

    public String getOSVersion() {
        return this.internalJSDL.getOSVersion();
    }

    public void addArgumentForPosixApplication(String argName, ArrayList<String> argValues) {
        this.internalJSDL.addArgumentForPosixApplication(argName, argValues);
    }

    public void addArgument(String argName) {
        this.internalJSDL.addArgument(argName);
    }

    public String getStdInputFileName() {
        return this.internalJSDL.getStdInputFileName();
    }

    public String getStdOutputFileName() {
        return this.internalJSDL.getStdOutputFileName();
    }

    public void addCandidateHosts(List<String> hostsList) {
        this.internalJSDL.addCandidateHosts(hostsList);
    }

    public List<DataStagingType> getDataStagingIn() {
        return this.internalJSDL.getDataStagingIn();
    }

    public Map<String, String> getDataStagingInStrings() {
        return this.internalJSDL.getDataStagingInStrings();
    }

    public Map<String, String> getDataStagingOutStrings() {
        return this.internalJSDL.getDataStagingOutStrings();
    }

    public List<DataStagingType> getDataStagingOut() {
        return this.internalJSDL.getDataStagingOut();
    }

    public void removeDataStaging() {
        this.internalJSDL.removeDataStaging();
    }

    public URI getStdOutputUri() throws ProblemException {
        return this.internalJSDL.getStdOutputUri();
    }

    public URI getStdInputUri() throws ProblemException {
        return this.internalJSDL.getStdInputUri();
    }

    public String getStdErrorFileName() {
        return this.internalJSDL.getStdErrorFileName();
    }

    public URI getStdErrorUri() throws ProblemException {
        return this.internalJSDL.getStdErrorUri();
    }

    public void setApplicationName(String applicationName) {
        this.internalJSDL.setApplicationName(applicationName);
    }

    public String getApplicationName() {
        return this.internalJSDL.getApplicationName();
    }

    public Document getXml() {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            doc = factory.newDocumentBuilder().parse(((IFile)this.getResource()).getContents());
        }
        catch (SAXException exception) {
            Activator.logException(exception);
        }
        catch (IOException exception) {
            Activator.logException(exception);
        }
        catch (ParserConfigurationException exception) {
            Activator.logException(exception);
        }
        catch (CoreException exception) {
            Activator.logException((Exception)((Object)exception));
        }
        return doc;
    }

    public String getAsString() throws ProblemException {
        StringBuilder builder = new StringBuilder();
        try {
            int readChars;
            InputStream inputStream = ((IFile)this.getResource()).getContents();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            char[] buffer = new char[1024];
            while ((readChars = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, readChars);
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            throw new ProblemException("eu.geclipse.jsdl.problem.getAsStringFailed", (Throwable)exception, "eu.geclipse.jsdl");
        }
        return builder.toString();
    }

    public List<String> getCandidateHostsNames() {
        return this.internalJSDL.getCandidateHostsNames();
    }

    public boolean isParametric() {
        return this.internalJSDL.isParametric();
    }

    public void removeTargetsFromOutStaging() {
        this.internalJSDL.removeTargetsFromOutStaging();
    }
}

