/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl;

import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.reporting.ReportingPlugin;
import eu.geclipse.jsdl.Messages;
import eu.geclipse.jsdl.internal.Activator;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class JSDLTransformer {
    public static String transformJSDL(InputStream jsdlStream, String targetType, Bundle bundle, IPath xsltFile) throws ProblemException {
        StringWriter outputWriter;
        InputStream xsltStream;
        try {
            xsltStream = FileLocator.openStream((Bundle)bundle, (IPath)xsltFile, (boolean)false);
            StreamSource xmlSource = new StreamSource(jsdlStream);
            StreamSource xsltSource = new StreamSource(xsltStream);
            outputWriter = new StringWriter();
            StreamResult result = new StreamResult(outputWriter);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = null;
            trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (TransformerConfigurationException e) {
            throw new ProblemException("eu.geclipse.core.problem.io.unspecified", Messages.getString("JSDLTransformer.canNotGetXSLTTransformer"), (Throwable)e, "eu.geclipse.jsdl");
        }
        catch (TransformerException e) {
            ProblemException pex = new ProblemException("eu.geclipse.core.problem.io.unspecified", Messages.getString("JSDLTransformer.canNotTransformJSDL"), (Throwable)e, "eu.geclipse.jsdl");
            ISolution solution = ReportingPlugin.getReportingService().createSolution(Messages.getString("JSDLTransformer.checkJSDLCorrect"), null);
            pex.getProblem().addSolution(solution);
            throw pex;
        }
        catch (IOException e) {
            ProblemException problemException = new ProblemException("eu.geclipse.core.problem.io.unspecified", (Throwable)e, "eu.geclipse.jsdl");
            problemException.getProblem().addReason(Messages.getString("JSDLTransformer.canNotFindXSLTFile"));
            throw problemException;
        }
        try {
            if (xsltStream != null) {
                xsltStream.close();
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "eu.geclipse.jsdl", 0, Messages.getString("JSDLTransformer.errorClosingStreams"), (Throwable)e);
            Activator.logStatus((IStatus)status);
        }
        return ((Object)outputWriter).toString();
    }
}

