/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.parametric.eclipse;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.parametric.IGeneratedJsdl;
import eu.geclipse.jsdl.parametric.IParametricJsdlHandler;
import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.parametric.eclipse.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricJsdlSaver
implements IParametricJsdlHandler {
    private JSDLJobDescription parametricJsdl;
    private IFolder targetFolder;
    private List<JSDLJobDescription> generatedJsdlList;
    private SubMonitor monitor;

    public ParametricJsdlSaver(JSDLJobDescription parametricJsdl, IFolder targetFolder, SubMonitor subMonitor) {
        this.parametricJsdl = parametricJsdl;
        this.targetFolder = targetFolder;
        this.monitor = subMonitor;
    }

    @Override
    public void newJsdlGenerated(IGeneratedJsdl generatedJsdl) throws ParametricJsdlException {
        try {
            this.saveJsdl(generatedJsdl);
        }
        catch (ProblemException exception) {
            throw new ParametricJsdlException(Messages.ParametricJsdlSaver_errUnableToSaveGeneratedJsdl, (Exception)((Object)exception));
        }
        this.monitor.worked(1);
    }

    private void saveJsdl(IGeneratedJsdl generatedJsdl) throws ProblemException {
        try {
            IFile file = this.targetFolder.getFile(this.getFileName(generatedJsdl));
            DOMSource source = new DOMSource(generatedJsdl.getDocument());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, new StreamResult(outputStream));
            outputStream.close();
            file.create((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), 256, null);
            IGridElement gridElement = GridModel.getRoot().findElement((IResource)file);
            Assert.isNotNull((Object)gridElement);
            if (gridElement != null) {
                this.generatedJsdlList.add((JSDLJobDescription)gridElement);
            }
        }
        catch (TransformerException exception) {
            throw new ProblemException("eu.geclipse.jsdl.problem.saveGeneratedJsdlFailed", (Throwable)exception, "eu.geclipse.jsdl");
        }
        catch (FileNotFoundException exception) {
            throw new ProblemException("eu.geclipse.jsdl.problem.saveGeneratedJsdlFailed", (Throwable)exception, "eu.geclipse.jsdl");
        }
        catch (IOException exception) {
            throw new ProblemException("eu.geclipse.jsdl.problem.saveGeneratedJsdlFailed", (Throwable)exception, "eu.geclipse.jsdl");
        }
        catch (CoreException exception) {
            throw new ProblemException("eu.geclipse.jsdl.problem.saveGeneratedJsdlFailed", (Throwable)exception, "eu.geclipse.jsdl");
        }
    }

    private String getFileName(IGeneratedJsdl generatedJsdl) {
        return String.format("%s%s.jsdl", new Path(this.parametricJsdl.getName()).lastSegment(), generatedJsdl.getIterationName());
    }

    @Override
    public void generationFinished() throws ParametricJsdlException {
        this.monitor.done();
    }

    @Override
    public void generationStarted(int generatedJsdl, List<String> paramNames) throws ParametricJsdlException {
        try {
            this.monitor.subTask(Messages.ParametricJsdlSaver_taskGeneratingJsdl);
            this.generatedJsdlList = new ArrayList<JSDLJobDescription>();
            this.monitor.setWorkRemaining(generatedJsdl);
            this.deleteTargetFolder();
            this.createTargetFolder();
        }
        catch (ProblemException exception) {
            throw new ParametricJsdlException(Messages.ParametricJsdlSaver_errUnableToPrepareFolder, (Exception)((Object)exception));
        }
    }

    private void deleteTargetFolder() throws ProblemException {
        if (this.targetFolder.exists()) {
            try {
                this.targetFolder.delete(true, null);
            }
            catch (CoreException exception) {
                String msg = String.format(Messages.ParametricJsdlSaver_errCannotDeleteFolder, this.targetFolder.getLocation().toString());
                throw new ProblemException("eu.geclipse.jsdl.problem.deleteExistingFolderFailed", msg, (Throwable)exception, "eu.geclipse.jsdl");
            }
        }
    }

    private void createTargetFolder() throws ProblemException {
        ArrayList<IFolder> parentList = new ArrayList<IFolder>();
        IFolder container = this.targetFolder;
        while (container instanceof IFolder) {
            parentList.add(container);
            container = container.getParent();
        }
        ListIterator iterator = parentList.listIterator(parentList.size());
        while (iterator.hasPrevious()) {
            IFolder folder = (IFolder)iterator.previous();
            if (folder.exists()) continue;
            try {
                folder.create(true, true, null);
            }
            catch (CoreException exception) {
                String msg = String.format(Messages.ParametricJsdlSaver_errCannotCreateFolder, folder.getLocation().toString());
                throw new ProblemException("eu.geclipse.jsdl.problem.createFolderFailed", msg, (Throwable)exception, "eu.geclipse.jsdl");
            }
        }
    }

    public List<JSDLJobDescription> getGeneratedJsdl() {
        return this.generatedJsdlList;
    }

    @Override
    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }
}

