/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.parametric.internal;

import eu.geclipse.jsdl.parametric.IGeneratedJsdl;
import eu.geclipse.jsdl.parametric.IParametricJsdlHandler;
import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.parametric.internal.IGenerationContext;
import eu.geclipse.jsdl.xpath.XPathDocument;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationContext
implements IGenerationContext,
IGeneratedJsdl {
    private IParametricJsdlHandler handler;
    private Document currentJsdl;
    private String currentJsdlName;
    private XPathDocument xpath;

    GenerationContext(Document baseJsdl, IParametricJsdlHandler handler, XPathDocument xpathDocument) {
        this.handler = handler;
        this.currentJsdl = baseJsdl;
        this.xpath = xpathDocument;
    }

    @Override
    public IGenerationContext clone() {
        GenerationContext newContext = new GenerationContext((Document)this.currentJsdl.cloneNode(true), this.handler, this.xpath);
        return newContext;
    }

    @Override
    public void setValue(String xpathQuery, String value) throws ParametricJsdlException {
        try {
            NodeList nodeList = this.xpath.getNodes(this.currentJsdl, xpathQuery);
            int index = 0;
            while (index < nodeList.getLength()) {
                Node item = nodeList.item(index);
                item.setTextContent(value);
                ++index;
            }
            this.updateJsdlDescription(xpathQuery, value);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ParametricJsdlException("Error occured during calling XPath query");
        }
    }

    @Override
    public void storeGeneratedJsdl(List<Integer> iterationsStack) throws ParametricJsdlException {
        this.currentJsdlName = this.createIterationName(iterationsStack);
        this.handler.newJsdlGenerated(this);
    }

    private String createIterationName(List<Integer> iterationsStack) {
        StringBuilder builder = new StringBuilder();
        for (Integer iteration : iterationsStack) {
            builder.append(String.format("[%03d]", iteration));
        }
        return builder.toString();
    }

    private void updateJsdlDescription(String paramName, String value) throws XPathExpressionException {
        NodeList nodes = this.xpath.getNodes(this.currentJsdl.getDocumentElement(), "jsdl:JobDescription/jsdl:JobIdentification/jsdl:Description");
        Element description = null;
        description = nodes == null || nodes.getLength() == 0 ? this.createXmlElement(this.currentJsdl.getDocumentElement(), "jsdl:JobDescription/jsdl:JobIdentification/jsdl:Description") : (Element)nodes.item(0);
        description.setTextContent(this.getDescriptionString(description.getTextContent(), paramName, value));
    }

    private String getDescriptionString(String currentDescription, String paramName, String value) {
        int begin = paramName.lastIndexOf("/") + 1;
        String newEntry = String.format("%s=%s", paramName.substring(begin), value);
        return currentDescription == null || currentDescription.length() == 0 ? newEntry : String.valueOf(currentDescription) + "\n" + newEntry;
    }

    @Override
    public Document getDocument() {
        return this.currentJsdl;
    }

    @Override
    public String getIterationName() {
        return this.currentJsdlName;
    }

    @Override
    public String getParamValue(String paramName) throws ParametricJsdlException {
        try {
            return this.xpath.getValue(this.currentJsdl, paramName);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ParametricJsdlException("Error occured during calling XPath query");
        }
    }

    private Element createXmlElement(Element parent, String pathString) throws XPathExpressionException {
        Element element = parent;
        String[] stringArray = pathString.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String currentNodeName = stringArray[n2];
            NodeList nodes = this.xpath.getNodes(element, "./" + currentNodeName);
            if (nodes == null || nodes.getLength() == 0) {
                int namespaceIndex = currentNodeName.indexOf(":");
                if (namespaceIndex > -1 && namespaceIndex + 1 < currentNodeName.length()) {
                    currentNodeName = currentNodeName.substring(namespaceIndex + 1);
                }
                Element newElement = this.currentJsdl.createElementNS("http://schemas.ggf.org/jsdl/2005/11/jsdl", currentNodeName);
                element.appendChild(newElement);
                element = newElement;
            } else {
                element = (Element)nodes.item(0);
            }
            ++n2;
        }
        return element;
    }

    @Override
    public IParametricJsdlHandler getHandler() {
        return this.handler;
    }
}

