/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.preferences;

import eu.geclipse.servicejob.model.ServiceJobStates;
import eu.geclipse.servicejob.ui.preferences.MementoHandler;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesManager {
    private static PreferencesManager singleton;
    private static Map<ServiceJobStates, Color> colorMap;

    private PreferencesManager() {
        colorMap = new HashMap<ServiceJobStates, Color>();
        colorMap = MementoHandler.loadState();
        if (colorMap.size() == 0) {
            colorMap = this.loadDefaultMap();
        }
    }

    private Map<ServiceJobStates, Color> loadDefaultMap() {
        HashMap<ServiceJobStates, Color> result = new HashMap<ServiceJobStates, Color>();
        ServiceJobStates[] serviceJobStatesArray = ServiceJobStates.values();
        int n = serviceJobStatesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceJobStates value = serviceJobStatesArray[n2];
            switch (value) {
                case CRITICAL: {
                    result.put(ServiceJobStates.CRITICAL, Display.getCurrent().getSystemColor(12));
                    break;
                }
                case ERROR: {
                    result.put(ServiceJobStates.ERROR, Display.getCurrent().getSystemColor(3));
                    break;
                }
                case NA: {
                    result.put(ServiceJobStates.NA, Display.getCurrent().getSystemColor(16));
                    break;
                }
                case OK: {
                    result.put(ServiceJobStates.OK, Display.getCurrent().getSystemColor(5));
                    break;
                }
                case RUNNING: {
                    result.put(ServiceJobStates.RUNNING, Display.getCurrent().getSystemColor(2));
                    break;
                }
                case WARNING: {
                    result.put(ServiceJobStates.WARNING, Display.getCurrent().getSystemColor(8));
                    break;
                }
            }
            ++n2;
        }
        return result;
    }

    public static PreferencesManager getManager() {
        if (singleton == null) {
            singleton = new PreferencesManager();
        }
        return singleton;
    }

    public Map<ServiceJobStates, Color> getColorMapping() {
        if (MementoHandler.isChanged()) {
            colorMap = MementoHandler.loadState();
        }
        return colorMap;
    }

    public Color getColor(String result) {
        return this.getColorMapping().get(ServiceJobStates.valueOfAlias((String)result));
    }

    public void saveState(Map<ServiceJobStates, Color> map) {
        MementoHandler.saveState(map);
    }
}

