/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.preferences;

import eu.geclipse.servicejob.model.ServiceJobStates;
import eu.geclipse.servicejob.ui.preferences.Messages;
import eu.geclipse.servicejob.ui.preferences.PreferencesManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ServiceJobPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Map<ServiceJobStates, Button> buttonsMap = new HashMap<ServiceJobStates, Button>();
    protected Map<ServiceJobStates, Color> colors = new HashMap<ServiceJobStates, Color>();
    protected boolean changed;

    protected Control createContents(final Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData();
        Label infoText = new Label(mainComp, 16384);
        infoText.setText(Messages.getString("OperatorJobsViewGeneralPreferences.preferences_title"));
        gData.horizontalSpan = 2;
        infoText.setLayoutData((Object)gData);
        ServiceJobStates[] serviceJobStatesArray = ServiceJobStates.values();
        int n = serviceJobStatesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceJobStates value = serviceJobStatesArray[n2];
            if (!value.equals((Object)ServiceJobStates.NULL)) {
                Label labelValue = new Label(mainComp, 16384);
                labelValue.setText(String.valueOf(Messages.getString("OperatorJobsViewGeneralPreferences.color_for")) + " &" + value.getAlias() + Messages.getString("OperatorJobsViewGeneralPreferences.result"));
                gData = new GridData();
                labelValue.setLayoutData((Object)gData);
                Button newButton = new Button(mainComp, 8);
                this.buttonsMap.put(value, newButton);
                Color colorButton = PreferencesManager.getManager().getColor(value.getAlias());
                this.buttonColor(colorButton, newButton);
                this.colors.put(value, colorButton);
                final ServiceJobStates valFinal = value;
                newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ColorDialog dialog = new ColorDialog(parent.getShell());
                        dialog.setText(String.valueOf(Messages.getString("OperatorJobsViewGeneralPreferences.select_color")) + valFinal.getAlias() + Messages.getString("OperatorJobsViewGeneralPreferences.result"));
                        RGB chosenColor = dialog.open();
                        if (chosenColor != null) {
                            Color newColor = new Color((Device)Display.getCurrent(), chosenColor);
                            ServiceJobPreferences.this.buttonColor(newColor, ServiceJobPreferences.this.buttonsMap.get(valFinal));
                            ServiceJobPreferences.this.colors.put(valFinal, newColor);
                            ServiceJobPreferences.this.changed = true;
                        }
                    }
                });
            }
            ++n2;
        }
        return mainComp;
    }

    public void init(IWorkbench workbench) {
    }

    protected final void buttonColor(Color color, Button button) {
        Color foreground = button.getForeground();
        Color background = color;
        int x = 0;
        int y = 0;
        Rectangle rect = button.getBounds();
        int width = rect.width;
        int height = rect.height;
        String text = button.getText();
        width = 30;
        height = 10;
        button.setImage(new Image((Device)button.getParent().getDisplay(), width, height));
        Image original = button.getImage();
        GC gc = new GC((Drawable)original);
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.drawRectangle(x, y, width, height);
        gc.fillRectangle(x, y, width, height);
        gc.setFont(button.getFont());
        int ximg = 2;
        int yimg = 2;
        gc.drawText(text, ximg > 4 ? ximg : 4, yimg > 4 ? yimg : 4, 9);
        gc.dispose();
        Image iDisable = new Image((Device)button.getParent().getDisplay(), original, 0);
        button.setImage(iDisable);
    }

    public boolean performOk() {
        PreferencesManager.getManager().saveState(this.colors);
        return super.performOk();
    }
}

