/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.views;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.core.model.IServiceJobResult;
import eu.geclipse.servicejob.ui.Activator;
import eu.geclipse.servicejob.ui.providers.DetailsContentProvider;
import eu.geclipse.servicejob.ui.providers.DetailsLabelProvider;
import eu.geclipse.servicejob.ui.views.Messages;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class ServiceJobDetailsView
extends ViewPart
implements ISelectionListener,
SelectionListener,
IGridModelListener {
    public static final String SERVICE_JOB_FILES_FOLDER = "./serviceJobFiles";
    protected Point pt = new Point(0, 0);
    int selectedColumnIndex;
    String selectedColumnText;
    TreeViewer viewer;
    IServiceJob rootElement;
    private DetailsContentProvider contentProvider;
    private DetailsLabelProvider labelProvider;
    private Composite parent;

    public ServiceJobDetailsView() {
        GridModel.addGridModelListener((IGridModelListener)this);
        this.contentProvider = new DetailsContentProvider(null);
        this.labelProvider = new DetailsLabelProvider();
    }

    public void createPartControl(Composite parent1) {
        this.parent = parent1;
        this.rootElement = this.findSelectedServiceJob();
        if (this.rootElement != null) {
            this.updateViewer(this.rootElement);
        } else {
            Composite mainComp = new Composite(parent1, 0);
            mainComp.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(mainComp, 16384);
            label.setText(Messages.getString("ServiceJobsDetailsView.no_service_job_selected"));
            label.setLayoutData((Object)new GridData());
        }
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void updateViewer(IServiceJob newInput) {
        this.createViewer(this.parent);
        ArrayList<TreeColumn> columns = new ArrayList<TreeColumn>();
        TreeColumn nameColumn = new TreeColumn(this.viewer.getTree(), 0);
        nameColumn.setText("Resource");
        nameColumn.setAlignment(16384);
        nameColumn.setWidth(200);
        if (newInput != null) {
            String[] properties = new String[newInput.getSingleServiceJobNames().size() + 1];
            properties[0] = Messages.getString("ServiceJobsDetailsView.name");
            int i = 0;
            for (String subServiceJob : newInput.getSingleServiceJobNames()) {
                columns.add(new TreeColumn(this.viewer.getTree(), 0));
                ((TreeColumn)columns.get(i)).setText(subServiceJob);
                ((TreeColumn)columns.get(i)).setAlignment(16384);
                ((TreeColumn)columns.get(i)).setWidth(newInput.getColumnWidth(subServiceJob));
                properties[i] = subServiceJob;
                ++i;
            }
        }
        ((DetailsContentProvider)this.viewer.getContentProvider()).changeRoot(newInput);
        ((DetailsLabelProvider)this.viewer.getLabelProvider()).changeRoot(newInput);
        this.viewer.setInput((Object)newInput);
        this.viewer.refresh();
        this.parent.redraw();
        this.parent.update();
        this.addSelectionListenerForEditor();
        this.parent.layout();
    }

    private void addSelectionListenerForEditor() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection structured;
                ISelection sel = event.getSelection();
                if (sel instanceof TreeSelection && (structured = (TreeSelection)sel).getFirstElement() instanceof List && ServiceJobDetailsView.this.selectedColumnIndex != 0) {
                    List list = (List)structured.getFirstElement();
                    for (IServiceJobResult result : list) {
                        IWorkbenchWindow window;
                        IWorkbenchPage page;
                        if (!result.getSubServiceJobName().equals(ServiceJobDetailsView.this.selectedColumnText) || ServiceJobDetailsView.this.rootElement.getInputStreamForResult(result) == null) continue;
                        String extension = result.getResultType();
                        if (extension == null || extension.equals("")) {
                            extension = "txt";
                        }
                        if ((page = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) == null) break;
                        try {
                            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("name." + extension);
                            if (desc != null) {
                                StreamStorage storage = new StreamStorage(ServiceJobDetailsView.this.rootElement.getInputStreamForResult(result), String.valueOf(result.getSubServiceJobName()) + " - " + result.getResourceName());
                                StreamInput editorInput = new StreamInput(storage, result);
                                page.openEditor((IEditorInput)editorInput, desc.getId());
                                break;
                            }
                            File fileForEditor = null;
                            fileForEditor = Activator.getFileForServiceJobResult(result);
                            if (fileForEditor == null) {
                                fileForEditor = ServiceJobDetailsView.this.serializeInputStream(ServiceJobDetailsView.this.rootElement.getInputStreamForResult(result), extension);
                                Activator.addFileForServiceJobResult(result, fileForEditor);
                            }
                            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileForEditor.toURI());
                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        }
                        catch (PartInitException e) {
                            Activator.logException(e);
                        }
                        break;
                    }
                }
            }
        });
        this.viewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) != 0) {
                    int width;
                    GC gc = event.gc;
                    Rectangle area = ServiceJobDetailsView.this.viewer.getTree().getClientArea();
                    int columnCount = ServiceJobDetailsView.this.viewer.getTree().getColumnCount();
                    if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                        Region region = new Region();
                        gc.getClipping(region);
                        region.add(event.x, event.y, width, event.height);
                        gc.setClipping(region);
                        region.dispose();
                    }
                    gc.setAdvanced(true);
                    if (gc.getAdvanced()) {
                        gc.setAlpha(127);
                    }
                    Rectangle rect = event.getBounds();
                    TreeItem item = ServiceJobDetailsView.this.viewer.getTree().getItem(ServiceJobDetailsView.this.pt);
                    int i = 0;
                    while (i < ServiceJobDetailsView.this.viewer.getTree().getColumnCount()) {
                        Rectangle rect1;
                        if (item != null && (rect1 = item.getBounds(i)).contains(ServiceJobDetailsView.this.pt)) {
                            rect = rect1;
                        }
                        ++i;
                    }
                    gc.setForeground(Display.getCurrent().getSystemColor(26));
                    gc.setBackground(Display.getCurrent().getSystemColor(26));
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, false);
                    gc.setForeground(Display.getCurrent().getSystemColor(24));
                    gc.setBackground(Display.getCurrent().getSystemColor(25));
                    event.detail &= 0xFFFFFFFD;
                }
            }
        });
    }

    private void createViewer(Composite parent1) {
        TreeViewer tViewer = null;
        Control[] controlArray = parent1.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control comp = controlArray[n2];
            comp.dispose();
            ++n2;
        }
        tViewer = new TreeViewer(parent1, 268501762);
        Tree tree = tViewer.getTree();
        tree.setHeaderVisible(true);
        this.viewer = tViewer;
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.getTree().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = ServiceJobDetailsView.this.viewer.getTree().getItem(point);
                if (item != null) {
                    int i = 0;
                    while (i < ServiceJobDetailsView.this.viewer.getTree().getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(point)) {
                            if (!ServiceJobDetailsView.this.viewer.getTree().getItem(point).getText(i).equals("")) {
                                ServiceJobDetailsView.this.selectedColumnIndex = i;
                                ServiceJobDetailsView.this.selectedColumnText = ServiceJobDetailsView.this.viewer.getTree().getColumn(i).getText();
                                break;
                            }
                        } else {
                            ServiceJobDetailsView.this.selectedColumnText = "";
                            ServiceJobDetailsView.this.selectedColumnIndex = -1;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    File serializeInputStream(InputStream inputStream, String type) {
        File res = null;
        File serviceJobFolder = Activator.getDefault().getStateLocation().append(SERVICE_JOB_FILES_FOLDER).toFile();
        if (!serviceJobFolder.exists()) {
            serviceJobFolder.mkdir();
        }
        boolean fileCreated = false;
        String fileNameBase = "file";
        String fileNameSufix = "";
        int i = 0;
        while (!fileCreated) {
            String fileName = String.valueOf(fileNameBase) + fileNameSufix + "." + type;
            Path filePath = new Path(serviceJobFolder.getAbsolutePath());
            if (filePath.append(fileName).toFile().exists()) {
                fileNameSufix = Integer.toString(i);
                if (++i != 100) continue;
                break;
            }
            FilterOutputStream out = null;
            try {
                try {
                    File newFile = filePath.append(fileName).toFile();
                    fileCreated = true;
                    if (newFile.createNewFile()) {
                        int c;
                        out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
                        while ((c = inputStream.read()) != -1) {
                            ((DataOutputStream)out).writeByte(c);
                        }
                        res = newFile;
                    }
                }
                catch (IOException e) {
                    Activator.logException(e);
                    try {
                        inputStream.close();
                        if (out == null) continue;
                        out.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                if (out == null) continue;
                out.close();
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    protected IServiceJob findSelectedServiceJob() {
        Object obj;
        IServiceJob result = null;
        ISelection selection = this.getSite().getPage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IServiceJob) {
            result = (IServiceJob)obj;
        }
        return result;
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IServiceJob) {
            this.rootElement = (IServiceJob)obj;
            this.updateViewer((IServiceJob)obj);
            this.viewer.getTree().update();
            this.viewer.getTree().redraw();
            this.viewer.getTree().layout();
            this.parent.redraw();
            this.parent.update();
            this.parent.layout();
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void gridModelChanged(IGridModelEvent event) {
        if (event.getType() == 3) {
            IGridElement[] removedElements = event.getElements();
            if (this.viewer != null) {
                Control control = this.viewer.getControl();
                IGridElement[] iGridElementArray = removedElements;
                int n = removedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement elem = iGridElementArray[n2];
                    if (elem instanceof IServiceJob && !control.isDisposed()) {
                        Display display = control.getDisplay();
                        display.asyncExec(new Runnable(){

                            public void run() {
                                ServiceJobDetailsView.this.viewer.refresh(true);
                            }
                        });
                    }
                    ++n2;
                }
            }
        }
    }

    class StreamInput
    extends PlatformObject
    implements IStorageEditorInput {
        private IStorage storage;
        private IServiceJobResult result;

        StreamInput(IStorage sto, IServiceJobResult result) {
            this.storage = sto;
            this.result = result;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.storage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() {
            return this.storage;
        }

        public String getToolTipText() {
            return String.valueOf(Messages.getString("ServiceJobsDetailsView.results")) + ":" + this.storage.getName();
        }

        public boolean equals(Object obj) {
            boolean res = super.equals(obj);
            if (!res && obj instanceof StreamInput) {
                res = this.result.equals(((StreamInput)((Object)obj)).result);
            }
            return res;
        }

        public int hashCode() {
            return this.result.hashCode();
        }
    }

    class StreamStorage
    extends PlatformObject
    implements IStorage {
        private InputStream stream;
        private String name;

        StreamStorage(InputStream input, String name) {
            this.stream = input;
            this.name = name;
        }

        public InputStream getContents() throws CoreException {
            return this.stream;
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    class StringInput
    extends PlatformObject
    implements IStorageEditorInput {
        private IStorage storage;

        StringInput(IStorage storage) {
            this.storage = storage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.storage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() {
            return this.storage;
        }

        public String getToolTipText() {
            return String.valueOf(Messages.getString("ServiceJobsDetailsView.string_based_file")) + ": " + this.storage.getName();
        }
    }

    class StringStorage
    extends PlatformObject
    implements IStorage {
        private String string;

        StringStorage(String input) {
            this.string = input;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.string.getBytes());
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            int len = Math.min(5, this.string.length());
            return this.string.substring(0, len).concat("...");
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

