/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.views;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.core.model.IServiceJobStatusListener;
import eu.geclipse.servicejob.ui.Activator;
import eu.geclipse.servicejob.ui.actions.OpenServiceJobDialogAction;
import eu.geclipse.servicejob.ui.providers.ServiceJobContentProvider;
import eu.geclipse.servicejob.ui.providers.ServiceJobLabelProvider;
import eu.geclipse.servicejob.ui.views.Messages;
import eu.geclipse.servicejob.ui.wizard.JobSubmissionServiceWizard;
import eu.geclipse.ui.views.ElementManagerViewPart;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ServiceJobView
extends ElementManagerViewPart
implements IServiceJobStatusListener,
ISelectionProvider,
ISelectionChangedListener {
    boolean refreshedFirstTime;
    private OpenServiceJobDialogAction wizardAction;
    private StructuredViewer myViewer;
    private Action runJobAction;

    protected IGridElementManager getManager() {
        return GridModel.getServiceJobManager();
    }

    protected boolean createTreeColumns(Tree tree) {
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setText("Name");
        nameColumn.setAlignment(16384);
        nameColumn.setWidth(160);
        TreeColumn projectColumn = new TreeColumn(tree, 0);
        projectColumn.setText("Project");
        projectColumn.setAlignment(16384);
        projectColumn.setWidth(100);
        TreeColumn statusColumn = new TreeColumn(tree, 0);
        statusColumn.setText(Messages.getString("ServiceJobsView.status"));
        statusColumn.setAlignment(16384);
        statusColumn.setWidth(130);
        TreeColumn dateColumn = new TreeColumn(tree, 0);
        dateColumn.setText(Messages.getString("ServiceJobsView.operator_job_date"));
        dateColumn.setAlignment(16384);
        dateColumn.setWidth(130);
        TreeColumn typeColumn = new TreeColumn(tree, 0);
        typeColumn.setText(Messages.getString("ServiceJobsView.type"));
        typeColumn.setAlignment(16384);
        typeColumn.setWidth(60);
        return true;
    }

    public void gridModelChanged(IGridModelEvent event) {
        super.gridModelChanged(event);
        if (event.getType() == 3 || event.getType() == 1 || event.getType() == 2) {
            IGridElement[] removedElements = event.getElements();
            Control control = this.getViewer().getControl();
            IGridElement[] iGridElementArray = removedElements;
            int n = removedElements.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement elem = iGridElementArray[n2];
                if (elem instanceof IServiceJob && !control.isDisposed()) {
                    Display display = control.getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (ServiceJobView.this.refreshedFirstTime) {
                                ServiceJobView.this.getViewer().refresh(true);
                                ServiceJobView.this.refreshedFirstTime = false;
                            }
                            ServiceJobView.this.getViewer().refresh(true);
                        }
                    });
                    this.refreshViewer();
                }
                ++n2;
            }
        }
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new ServiceJobLabelProvider();
    }

    protected IContentProvider createContentProvider() {
        return new ServiceJobContentProvider();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        GridModel.getServiceJobManager().addServiceJobStatusListener((IServiceJobStatusListener)this);
        this.addSelectionChangedListener(this);
    }

    protected void initViewer(StructuredViewer viewer) {
        super.initViewer(viewer);
        this.myViewer = viewer;
        this.myViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createButtons();
        this.createMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.myViewer);
        this.refreshedFirstTime = true;
    }

    private void createButtons() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.wizardAction = new OpenServiceJobDialogAction();
        this.wizardAction.setToolTipText(Messages.getString("ServiceJobsView.new_operators_job_wizard"));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.wizardAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        URL runURL = Activator.getDefault().getBundle().getEntry("icons/obj16/debugt_obj.gif");
        ImageDescriptor runDesc = ImageDescriptor.createFromURL((URL)runURL);
        URL runDisabledURL = Activator.getDefault().getBundle().getEntry("icons/obj16/debugt_obj_disabled1.gif");
        ImageDescriptor runDisabledDesc = ImageDescriptor.createFromURL((URL)runDisabledURL);
        this.runJobAction = new Action(){

            public void run() {
                ISelection sel = ServiceJobView.this.getSelection();
                if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
                    IStructuredSelection sSel = (IStructuredSelection)sel;
                    for (Object obj : sSel.toList()) {
                        if (!(obj instanceof IServiceJob)) continue;
                        IServiceJob serviceJob = (IServiceJob)obj;
                        if (serviceJob.needsSubmissionWizard()) {
                            JobSubmissionServiceWizard serviceWizard = new JobSubmissionServiceWizard(serviceJob.getParent().getProject().getVO());
                            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)serviceWizard);
                            if (dialog.open() != 0) continue;
                            serviceJob.setSubmissionService(serviceWizard.getSelectedService());
                            serviceJob.run();
                            continue;
                        }
                        serviceJob.run();
                    }
                }
                super.run();
            }
        };
        this.runJobAction.setImageDescriptor(runDesc);
        this.runJobAction.setDisabledImageDescriptor(runDisabledDesc);
        this.runJobAction.setEnabled(!this.getSelection().isEmpty());
        this.runJobAction.setToolTipText(Messages.getString("ServiceJobsView.run_button_tooltip"));
        mgr.add((IAction)this.runJobAction);
        mgr.add((IAction)this.wizardAction);
        this.refreshViewer();
    }

    private void createMenu() {
    }

    public void statusChanged(IServiceJob serviceJob) {
        this.refreshViewer((IGridElement)serviceJob);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.myViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
        this.myViewer.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.runJobAction.setEnabled(!this.getSelection().isEmpty());
    }
}

