/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.wizard;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.servicejob.parsers.GTDLWriter;
import eu.geclipse.servicejob.ui.Activator;
import eu.geclipse.servicejob.ui.interfaces.IServiceJobWizardNode;
import eu.geclipse.servicejob.ui.internal.WizardInitObject;
import eu.geclipse.servicejob.ui.wizard.ProjectSelectionPage;
import eu.geclipse.ui.wizards.IProjectSelectionProvider;
import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionListPage;
import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import eu.geclipse.ui.wizards.wizardselection.WizardSelectionListPage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceJobWizard
extends Wizard
implements INewWizard,
IProjectSelectionProvider {
    static final String SERVICE_JOBS_FOLDER = ".serviceJobs";
    static final String SERVICE_JOB_EXTENSION = ".gtdl";
    private IGridProject project;
    private ProjectSelectionPage projectPage;
    private List<IGridResource> serviceJobResources;
    private WizardSelectionListPage serviceJobTypeSelectionPage;

    public ServiceJobWizard(IGridProject project, List<IGridResource> resource) {
        this.setForcePreviousAndNextButtons(true);
        this.project = project;
        this.serviceJobResources = resource;
    }

    public ServiceJobWizard() {
        this(null, null);
    }

    public String getWindowTitle() {
        return "New Operator's Job";
    }

    public void addPages() {
        this.projectPage = new ProjectSelectionPage("Project selection page", this.project);
        this.addPage((IWizardPage)this.projectPage);
        this.serviceJobTypeSelectionPage = new ExtPointWizardSelectionListPage("Operator's jobs' type selection page", "eu.geclipse.servicejob.servicejobProvider", "Operator's job type selection page", "Select type of operator's job you want to perform", "No jobs to choose from", false);
        this.addPage((IWizardPage)this.serviceJobTypeSelectionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.serviceJobTypeSelectionPage.setInitData((Object)new WizardInitObject(this.projectPage.getJobName(), this, this.serviceJobResources));
        IWizardPage result = super.getNextPage(page);
        this.serviceJobTypeSelectionPage.resetNodesVisibility();
        if (result instanceof ExtPointWizardSelectionListPage) {
            IWizardSelectionNode[] iWizardSelectionNodeArray = this.serviceJobTypeSelectionPage.getNodes();
            int n = iWizardSelectionNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardSelectionNode node = iWizardSelectionNodeArray[n2];
                if (node.getTempWizard() instanceof IServiceJobWizardNode && !((IServiceJobWizardNode)node.getTempWizard()).canHandle(this.projectPage.getProject().getVO())) {
                    this.serviceJobTypeSelectionPage.removeSelectionNode(node);
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean performFinish() {
        boolean result = true;
        IWizard selectedNode = this.serviceJobTypeSelectionPage.getSelectedNode().getWizard();
        if (selectedNode instanceof IServiceJobWizardNode) {
            IServiceJobWizardNode serviceJobNode = (IServiceJobWizardNode)selectedNode;
            IGridProject destinationProject = serviceJobNode.getSelectedProject();
            String serviceJobName = serviceJobNode.getServiceJobName();
            InputStream serviceJobInputData = serviceJobNode.getServiceJobInputData();
            String serviceJobPluginId = serviceJobNode.getPluginID();
            List<String> serviceJobResources1 = serviceJobNode.getResourcesNames();
            this.createServiceJob(serviceJobName, destinationProject, serviceJobInputData, serviceJobPluginId, serviceJobResources1);
        }
        if (result) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.servicejob.views.serviceJobsView");
            }
            catch (PartInitException partExc) {
                Activator.logException(partExc);
            }
        }
        return result;
    }

    private void createServiceJob(String serviceJobName, IGridProject gProject, InputStream inputStream, String plugInID, List<String> serviceJobResources1) {
        IPath projectPath = gProject.getPath();
        IPath serviceJobsFolderPath = projectPath.append("/.serviceJobs/");
        IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
        try {
            IFile serviceJobFile;
            IFolder serviceJobsFolder = workspaceRoot.getFolder(serviceJobsFolderPath);
            if (!serviceJobsFolder.exists()) {
                serviceJobsFolder.create(true, true, null);
            }
            if (!(serviceJobFile = serviceJobsFolder.getFile(String.valueOf(serviceJobName) + SERVICE_JOB_EXTENSION)).exists()) {
                serviceJobFile.create(GTDLWriter.getInitialInputStream((String)plugInID, serviceJobResources1, (InputStream)inputStream), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreExc) {
            Activator.logException(coreExc);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (TransformerException e) {
            Activator.logException(e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public List<IGridResource> getInitResources() {
        return this.serviceJobResources;
    }

    public IGridProject getGridProject() {
        IGridProject result = null;
        if (this.projectPage != null) {
            result = this.projectPage.getProject();
        }
        return result;
    }
}

