/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.util.TokenValidator;
import eu.geclipse.terminal.ssh.internal.Activator;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import eu.geclipse.ui.widgets.NumberVerifier;
import eu.geclipse.ui.widgets.StoredCombo;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class SSHConnectionComposite
extends Composite {
    private static final String sshDefaultPort = "22";
    private static final String USERNAMES = "usernames";
    private static final String HOSTNAMES = "hostnames";
    private Label usernameLabel = null;
    private StoredCombo usernameCombo = null;
    private Label hostnameLabel = null;
    private StoredCombo hostnameCombo = null;
    private Label passwordLabel = null;
    private Text passwordText = null;
    private Label portLabel = null;
    private Text portText = null;

    SSHConnectionComposite(Composite parent, int style, Listener page, String preSelectedHostname) {
        super(parent, style);
        this.initialize();
        Activator activator = Activator.getDefault();
        IPreferenceStore preferenceStore = activator.getPreferenceStore();
        this.usernameCombo.setPreferences(preferenceStore, USERNAMES);
        this.hostnameCombo.setPreferences(preferenceStore, HOSTNAMES);
        this.addComputingElements();
        if (preSelectedHostname != null) {
            this.hostnameCombo.setText(preSelectedHostname);
        }
        this.usernameCombo.addListener(24, page);
        this.hostnameCombo.addListener(24, page);
        this.passwordText.addListener(24, page);
        this.portText.addListener(24, page);
        this.portText.addListener(25, (Listener)new NumberVerifier());
        GridData portTextGridData = (GridData)this.portText.getLayoutData();
        GC gc = new GC((Drawable)this.portText);
        FontMetrics fm = gc.getFontMetrics();
        portTextGridData.widthHint = 7 * fm.getAverageCharWidth();
        gc.dispose();
    }

    private void addComputingElements() {
        IGridElement[] elements = null;
        try {
            IGridElement[] projectElements;
            IGridElement[] iGridElementArray = projectElements = GridModel.getRoot().getChildren(null);
            int n = projectElements.length;
            int n2 = 0;
            while (n2 < n) {
                IGridInfoService infoService;
                IGridElement element = iGridElementArray[n2];
                IGridProject igp = (IGridProject)element;
                if (igp.isOpen() && igp.getVO() != null && (infoService = igp.getVO().getInfoService()) != null) {
                    IGridElement[] iGridElementArray2 = elements = infoService.fetchResources(null, igp.getVO(), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing"), null);
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IGridComputing gridComputing;
                        String host;
                        IGridElement comp = iGridElementArray2[n4];
                        if (comp instanceof IGridComputing && (host = (gridComputing = (IGridComputing)comp).getHostName()) != null && this.hostnameCombo.indexOf(host) == -1) {
                            this.hostnameCombo.add(host);
                        }
                        ++n4;
                    }
                    Object[] items = this.hostnameCombo.getItems();
                    if (items != null && items.length > 0) {
                        Arrays.sort(items);
                        this.hostnameCombo.removeAll();
                        this.hostnameCombo.setItems((String[])items);
                    }
                }
                ++n2;
            }
        }
        catch (ProblemException e) {
            Activator.logException((Exception)((Object)e));
        }
    }

    private void initialize() {
        GridData portTextGridData = new GridData();
        portTextGridData.horizontalAlignment = 4;
        portTextGridData.grabExcessHorizontalSpace = false;
        portTextGridData.verticalAlignment = 2;
        GridData passwordTextGridData = new GridData();
        passwordTextGridData.horizontalAlignment = 4;
        passwordTextGridData.grabExcessHorizontalSpace = true;
        passwordTextGridData.horizontalSpan = 3;
        passwordTextGridData.verticalAlignment = 2;
        GridData hostnameComboGridData = new GridData();
        hostnameComboGridData.horizontalAlignment = 4;
        hostnameComboGridData.grabExcessHorizontalSpace = true;
        hostnameComboGridData.verticalAlignment = 2;
        GridData usernameComboGridData = new GridData();
        usernameComboGridData.horizontalAlignment = 4;
        usernameComboGridData.grabExcessHorizontalSpace = true;
        usernameComboGridData.horizontalSpan = 3;
        usernameComboGridData.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.hostnameLabel = new Label((Composite)this, 0);
        this.hostnameLabel.setText(Messages.getString("SSHConnectionComposite.hostName"));
        this.hostnameCombo = new StoredCombo((Composite)this, 4);
        this.hostnameCombo.setLayoutData((Object)hostnameComboGridData);
        this.portLabel = new Label((Composite)this, 0);
        this.portLabel.setText(Messages.getString("SSHConnectionComposite.port"));
        this.portText = new Text((Composite)this, 2048);
        this.portText.setTextLimit(5);
        this.portText.setText(sshDefaultPort);
        this.portText.setLayoutData((Object)portTextGridData);
        this.usernameLabel = new Label((Composite)this, 0);
        this.usernameLabel.setText(Messages.getString("SSHConnectionComposite.userName"));
        this.usernameCombo = new StoredCombo((Composite)this, 4);
        this.usernameCombo.setLayoutData((Object)usernameComboGridData);
        this.passwordLabel = new Label((Composite)this, 0);
        this.passwordLabel.setText(Messages.getString("SSHConnectionComposite.password"));
        this.passwordText = new Text((Composite)this, 0x400800);
        this.passwordText.setLayoutData((Object)passwordTextGridData);
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(300, 200));
    }

    IStatus getStatus() {
        Integer port = null;
        boolean validPort = true;
        try {
            port = new Integer(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        if (port == null || port < 1 || port > 65535) {
            validPort = false;
        }
        Status status = new Status(0, "eu.geclipse.terminal.ssh", 0, "", null);
        if (this.hostnameCombo.getText().length() == 0) {
            status = new Status(4, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.hostNameMustNotBeEmpty"), null);
        } else if (!validPort) {
            status = new Status(4, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.AValidPortNumberMustBeEntered"), null);
        } else if (!TokenValidator.validateFQHN((String)this.hostnameCombo.getText())) {
            status = new Status(2, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.invalidHostname"), null);
        } else if (this.passwordText.getText().length() == 0) {
            status = new Status(1, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.passwordIsRequiredIfYouAreNotUsingPubKeyAuth"), null);
        }
        return status;
    }

    SSHConnectionInfo getConnectionInfo() {
        return new SSHConnectionInfo(this.usernameCombo.getText(), this.hostnameCombo.getText(), this.passwordText.getText(), null, new Integer(this.portText.getText()));
    }
}

