/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.ui.dialogs.PasswordDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

class SSHConnectionInfo
implements UserInfo,
UIKeyboardInteractive {
    String passphrase;
    String passwd;
    boolean canceledPWValue;
    private String user;
    private String host;
    private int port;
    private boolean promptPasswd;
    private boolean promptPassphrase;
    private boolean passwordInteractiveUsed;
    private String[] keyboardInteractiveResult;

    SSHConnectionInfo(String username, String hostname, String password, String passphrase, int portNumber) {
        this.user = username;
        this.host = hostname;
        this.passwd = password;
        this.promptPasswd = this.passwd == null || this.passwd.length() == 0;
        this.passphrase = passphrase;
        this.promptPassphrase = this.passphrase == null || this.passphrase.length() == 0;
        this.port = portNumber;
        this.canceledPWValue = false;
    }

    public String getPassword() {
        this.promptPasswd = true;
        return this.passwd;
    }

    String getUsername() {
        return this.user;
    }

    String getHostname() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    public boolean promptYesNo(final String str) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                result[0] = MessageDialog.openQuestion(null, (String)Messages.getString("SshShell.sshTerminal"), (String)str);
            }
        });
        return result[0];
    }

    public String getPassphrase() {
        this.promptPassphrase = true;
        return this.passphrase;
    }

    public boolean promptPassphrase(final String message) {
        final int[] result = new int[1];
        if (this.promptPassphrase) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    PasswordDialog dlg = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SshShell.sshTerminal"), message, null, null);
                    result[0] = dlg.open();
                    if (result[0] == 0) {
                        SSHConnectionInfo.this.passphrase = dlg.getValue();
                    } else {
                        SSHConnectionInfo.this.canceledPWValue = true;
                    }
                }
            });
        }
        return result[0] == 0;
    }

    public boolean promptPassword(final String message) {
        final int[] result = new int[1];
        if (this.promptPasswd) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    PasswordDialog dlg = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SshShell.sshTerminal"), message, null, null);
                    result[0] = dlg.open();
                    if (result[0] == 0) {
                        SSHConnectionInfo.this.passwd = dlg.getValue();
                    } else {
                        SSHConnectionInfo.this.canceledPWValue = true;
                    }
                }
            });
        }
        return result[0] == 0;
    }

    public void showMessage(final String message) {
        if (message != null && message.trim().length() != 0) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation(null, (String)Messages.getString("SshShell.sshTerminal"), (String)message);
                }
            });
        }
    }

    public boolean getCanceledPWValue() {
        return this.canceledPWValue;
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, final String[] prompt, boolean[] echo) {
        String[] result;
        if (this.passwordInteractiveUsed) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    PasswordDialog dlg = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SshShell.sshTerminal"), prompt[0], null, null);
                    dlg.open();
                    SSHConnectionInfo.this.keyboardInteractiveResult = new String[]{dlg.getValue()};
                }
            });
            result = this.keyboardInteractiveResult;
        } else {
            this.passwordInteractiveUsed = true;
            result = new String[]{this.passwd};
        }
        return result;
    }
}

