/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import eu.geclipse.terminal.ITerminalView;
import eu.geclipse.terminal.ssh.internal.Activator;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import eu.geclipse.terminal.ssh.internal.SSHConnectionWizardPage;
import eu.geclipse.terminal.ssh.internal.SshShell;
import eu.geclipse.ui.wizards.portforward.PortForwardOptionsWizardPage;
import eu.geclipse.ui.wizards.wizardselection.IInitializableWizard;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SSHWizard
extends Wizard
implements IInitializableWizard {
    SSHConnectionWizardPage mainPage;
    ITerminalView termView;
    PortForwardOptionsWizardPage portForwardPage;
    private String preSelectedHostname;

    public SSHWizard() {
    }

    public SSHWizard(String preSelectedHostname) {
        this.preSelectedHostname = preSelectedHostname;
        try {
            this.termView = (ITerminalView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.terminal.views.TerminalView");
        }
        catch (PartInitException exception) {
            Activator.logException((Exception)((Object)exception));
        }
    }

    public boolean performFinish() {
        final SSHConnectionInfo info = this.mainPage.getConnectionInfo();
        final List forwards = this.portForwardPage.getForwards();
        Job job = new Job(Messages.getString("SSHWizard.openingSSHTerminal")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("SSHWizard.openingSSHTerminal"), 1);
                monitor.subTask(Messages.getString("SSHWizard.connecting"));
                SshShell sshShell = new SshShell();
                sshShell.createTerminal(SSHWizard.this.termView, info, forwards);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    public void addPages() {
        this.mainPage = new SSHConnectionWizardPage(Messages.getString("SSHWizard.ssh"));
        this.mainPage.setPreselectedHostname(this.preSelectedHostname);
        this.portForwardPage = new PortForwardOptionsWizardPage(Messages.getString("SSHWizard.ssh"));
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.portForwardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("SSHWizard.ssh");
    }

    public String toString() {
        return Messages.getString("SSHWizard.ssh");
    }

    public boolean init(Object data) {
        boolean result = false;
        if (data instanceof ITerminalView) {
            this.termView = (ITerminalView)data;
            URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/newconn_wiz.gif");
            this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
            result = true;
        }
        return result;
    }
}

