/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.debug;

import eu.geclipse.traceview.debug.listeners.BreakpointListener;
import eu.geclipse.traceview.debug.listeners.DebugEventListener;
import eu.geclipse.traceview.debug.listeners.LaunchListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.geclipse.traceview.debug";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener((IDebugEventSetListener)new DebugEventListener());
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)new LaunchListener());
        IBreakpointManager breakpointManager = debugPlugin.getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)new BreakpointListener());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Exception exception) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            message = exception.getClass().getName();
        }
        Status status = new Status(4, PLUGIN_ID, 0, message, (Throwable)exception);
        Activator.getDefault().getLog().log((IStatus)status);
    }
}

