/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.debug.listeners;

import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.debug.Activator;
import eu.geclipse.traceview.debug.EventBreakpoint;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpointFilterExtension;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BreakpointListener
implements IBreakpointListener {
    private void redraw(IBreakpoint breakpoint) {
        if (breakpoint instanceof ICLineBreakpoint) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ITraceView traceView = (ITraceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
                        traceView.redraw();
                    }
                    catch (PartInitException partInitException) {
                        Activator.logException((Exception)((Object)partInitException));
                    }
                }
            });
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.redraw(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof EventBreakpoint) {
            EventBreakpoint eventBreakPoint = (EventBreakpoint)breakpoint;
            try {
                ICBreakpointFilterExtension extension = (ICBreakpointFilterExtension)eventBreakPoint.getExtension(CDIDebugModel.getPluginIdentifier(), ICBreakpointFilterExtension.class);
                ICDebugTarget[] iCDebugTargetArray = extension.getTargetFilters();
                int n = iCDebugTargetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICDebugTarget target = iCDebugTargetArray[n2];
                    try {
                        while (!target.isSuspended()) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Activator.logException(interruptedException);
                    }
                    int processID = Integer.parseInt(target.toString().substring(target.toString().lastIndexOf("s ") + 2, target.toString().indexOf("(") - 1));
                    if (eventBreakPoint.getProcess() != processID) {
                        extension.removeTargetFilter(target);
                    }
                    ++n2;
                }
            }
            catch (CoreException exception) {
                Activator.logException((Exception)((Object)exception));
            }
        }
        this.redraw(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.redraw(breakpoint);
    }
}

