/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.nope.markers;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.nope.Activator;
import eu.geclipse.traceview.nope.preferences.PreferenceConstants;
import eu.geclipse.traceview.nope.tracereader.Event;
import eu.geclipse.traceview.utils.AbstractEventMarker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NopeEventMarker
extends AbstractEventMarker {
    private IPreferenceStore store;
    private Color foreground;
    private Color background;
    private Color canvasBackground;
    private Color[] colors = new Color[PreferenceConstants.Names.length];
    private boolean[] enabled = new boolean[PreferenceConstants.Names.length];
    private int[] shapes = new int[PreferenceConstants.Names.length];
    private Color messageColor;

    public NopeEventMarker() {
        this.store = Activator.getDefault().getPreferenceStore();
        this.updateFromPreferences();
        this.store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NopeEventMarker.this.handleProperyChanged(event);
            }
        });
    }

    private void updateFromPreferences() {
        int i = 0;
        while (i < PreferenceConstants.Names.length) {
            this.colors[i] = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)this.store, (String)(String.valueOf(PreferenceConstants.Names[i]) + "color")));
            ++i;
        }
        i = 0;
        while (i < PreferenceConstants.Names.length) {
            this.enabled[i] = this.store.getBoolean(String.valueOf(PreferenceConstants.Names[i]) + "enabled");
            ++i;
        }
        i = 0;
        while (i < PreferenceConstants.Names.length) {
            this.shapes[i] = this.store.getInt(String.valueOf(PreferenceConstants.Names[i]) + "shape");
            ++i;
        }
    }

    protected void handleProperyChanged(PropertyChangeEvent event) {
        boolean running = true;
        int i = 0;
        while (i < PreferenceConstants.Names.length && running) {
            if (event.getProperty().equals(String.valueOf(PreferenceConstants.Names[i]) + "color")) {
                this.colors[i].dispose();
                this.colors[i] = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)this.store, (String)(String.valueOf(PreferenceConstants.Names[i]) + "color")));
                running = false;
            } else if (event.getProperty().equals(String.valueOf(PreferenceConstants.Names[i]) + "enabled")) {
                this.enabled[i] = this.store.getBoolean(String.valueOf(PreferenceConstants.Names[i]) + "enabled");
                running = false;
            } else if (event.getProperty().equals(String.valueOf(PreferenceConstants.Names[i]) + "shape")) {
                this.shapes[i] = this.store.getInt(String.valueOf(PreferenceConstants.Names[i]) + "shape");
                running = false;
            }
            ++i;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ITraceView traceView = (ITraceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
                    traceView.redraw();
                }
                catch (PartInitException exception) {
                    Activator.logException((Exception)((Object)exception));
                }
            }
        });
    }

    public Color getForegroundColor(int type) {
        return this.foreground;
    }

    public Color getBackgroundColor(int type) {
        return this.background;
    }

    public Color getMessageColor() {
        return this.messageColor;
    }

    public Color getCanvasBackgroundColor() {
        return this.canvasBackground;
    }

    public int mark(IEvent event) {
        boolean running = true;
        if (event instanceof Event) {
            Event nopeEvent = (Event)event;
            int i = 0;
            while (i < PreferenceConstants.Names.length && running) {
                if (this.enabled[i] && nopeEvent.getSubType() == PreferenceConstants.Codes[i]) {
                    int cfr_ignored_0 = this.shapes[i];
                    this.foreground = this.colors[i];
                    this.background = null;
                }
                ++i;
            }
            Event lenCheckEvent = nopeEvent;
            if (nopeEvent.getType().equals((Object)EventType.SEND)) {
                lenCheckEvent = (Event)nopeEvent.getPartnerEvent();
            }
            this.messageColor = Display.getDefault().getSystemColor(2);
            if (lenCheckEvent != null && lenCheckEvent.getType().equals((Object)EventType.RECV)) {
                if (lenCheckEvent.getAcceptedMessageLength() > lenCheckEvent.getSupposedMessageLength()) {
                    this.messageColor = Display.getDefault().getSystemColor(3);
                } else if (lenCheckEvent.getAcceptedMessageLength() < lenCheckEvent.getSupposedMessageLength()) {
                    this.messageColor = Display.getDefault().getSystemColor(7);
                }
            }
            this.canvasBackground = nopeEvent.getType().equals((Object)EventType.RECV) && nopeEvent.getSupposedPartnerProcess() == -1 ? Display.getDefault().getSystemColor(15) : null;
        }
        return 4;
    }
}

