/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.nope.tracereader;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.nope.Activator;
import eu.geclipse.traceview.nope.tracereader.ArrayEvent;
import eu.geclipse.traceview.nope.tracereader.Event;
import eu.geclipse.traceview.nope.tracereader.Trace;
import eu.geclipse.traceview.nope.tracereader.VecEvent;
import eu.geclipse.traceview.utils.AbstractProcessFileCache;
import eu.geclipse.traceview.utils.AbstractTraceFileCache;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Process
extends AbstractProcessFileCache {
    public static byte trcLittleEndian = (byte)-128;
    public static byte trcBigEndian = 0;
    public static byte trcPartial = 0;
    public static byte trcTotal = (byte)64;
    public static byte trcWithout = 0;
    public static byte trcWith = (byte)32;
    public static byte trcFunctions = 0;
    public static byte trcMacros = (byte)8;
    public static byte trcAssembler = (byte)16;
    public static byte trcTraps = (byte)24;
    public static byte trcMinimum = 0;
    public static byte trcMedium = (byte)2;
    public static byte trcMaximum = (byte)6;
    public static byte trcNCUBE = 0;
    public static byte trcPARSYTEC = 1;
    public static byte trcFALSE = 0;
    public static byte trcTRUE = (byte)-128;
    public static byte trcNoEv = 0;
    public static byte trcRecv = 1;
    public static byte trcSend = (byte)2;
    public static byte trcTest = (byte)3;
    public static byte trcSourceLine = (byte)4;
    public static byte trcOthers = (byte)5;
    public static byte trcTrace = (byte)7;
    public static byte trcTVarInsp = 0;
    public static byte trcTFlush = 1;
    public static byte trcTOnOff = (byte)2;
    public static byte trcTTimer = (byte)3;
    public static byte trcTMsgQueue = (byte)4;
    public static byte trcTTestLoop = (byte)5;
    public static byte trcTArrInsp = (byte)6;
    private static final String PROP_ID = "Process.Id";
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"Process.Id", "Process ID")};
    private String traceFileName;
    private int fileSize;
    private int version;
    private boolean isTrcBigEndian;
    private int traceAmount;
    private boolean source;
    private int level;
    private int dataAmount;
    private int multiprocessor;
    private String filename;
    private String arguments;
    private int monStrat;
    private int monPModel;
    private int monStor;
    private int monError;
    private int monFlush;
    private int monBuffer;
    private long runTimeStart;
    private HashMap<Integer, Integer> ignoreCounts = new HashMap();
    private int previousLogicalClock = -1;
    private boolean debug = false;
    private int sourceFilenameIndex;
    private int[] initialVectorClock;
    private boolean supportsVectorClocks;
    private DataInputStream dataInputStream = null;

    protected Process(File traceFile, int processId, boolean hasCache, Trace trace) {
        super((AbstractTraceFileCache)trace, processId);
        this.supportsVectorClocks = trace.supportsVectorClocks();
        if (this.supportsVectorClocks) {
            this.initialVectorClock = new int[trace.getNumberOfProcesses()];
            int i = 0;
            while (i < this.initialVectorClock.length) {
                this.initialVectorClock[i] = -1;
                ++i;
            }
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(traceFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.dataInputStream = new DataInputStream(bufferedInputStream);
            this.traceFileName = traceFile.getAbsolutePath();
            this.fileSize = fileInputStream.available();
            this.readHeader();
            if (this.debug) {
                this.headerInfo();
            }
            if (!hasCache) {
                Event event = null;
                while ((event = this.readEvent()) != null) {
                    if (!this.debug) continue;
                    this.eventInfo(event);
                }
            }
        }
        catch (EOFException eOFException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            Activator.logException(fileNotFoundException);
        }
        catch (IOException ioException) {
            Activator.logException(ioException);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        return this.getProcessId();
    }

    public Event getEventByLogicalClock(int index) throws IndexOutOfBoundsException {
        Event result = null;
        if (index <= this.getMaximumLogicalClock()) {
            result = this.supportsVectorClocks ? new VecEvent(index, this) : new Event(index, this);
        }
        return result;
    }

    private int readInt() throws IOException {
        int result = this.dataInputStream.readInt();
        if (!this.isTrcBigEndian) {
            result = Integer.reverseBytes(result);
        }
        return result;
    }

    private long readLong() throws IOException {
        long result = this.dataInputStream.readLong();
        if (!this.isTrcBigEndian) {
            result = Long.reverseBytes(result);
        }
        return result;
    }

    private void debugOutput(String message) {
    }

    private void headerInfo() {
        this.debugOutput("version of trace file : " + this.version);
        this.debugOutput("processor             : " + this.processId);
        this.debugOutput("filename:             : " + this.traceFileName);
        this.debugOutput("filesize:             : " + this.fileSize);
        if (this.isTrcBigEndian) {
            this.debugOutput("byte ordering         : big endian");
        } else {
            this.debugOutput("byte ordering         : little endian");
        }
        this.debugOutput("trace amount          : " + this.traceAmount);
        this.debugOutput("source switch         : " + this.source);
        this.debugOutput("level of impl         : " + this.level);
        this.debugOutput("data amount           : " + this.dataAmount);
        this.debugOutput("multiprocessor        : " + this.multiprocessor);
        this.debugOutput("program name          : " + this.filename);
        this.debugOutput("program args          : " + this.arguments);
        this.debugOutput("run time start        : " + this.runTimeStart);
        this.debugOutput("mon strategy          : " + this.monStrat);
        this.debugOutput("model of prog         : " + this.monPModel);
        this.debugOutput("error mon             : " + this.monError);
        this.debugOutput("flushing mode         : " + this.monFlush);
        this.debugOutput("file buffer           : " + this.monBuffer);
        this.debugOutput("tracing disk          : " + this.monStor);
    }

    private void eventInfo(Event event) {
        this.debugOutput("Type: " + event.getType());
        this.debugOutput("");
        this.debugOutput("traceComm.blocking: " + event.getBlocking());
        this.debugOutput("traceComm.commname: " + event.getSubType());
        this.debugOutput("");
        this.debugOutput("(traceComm.supposed)->partner: " + event.getSupposedPartnerProcess());
        this.debugOutput("(traceComm.supposed)->msgtype: " + event.getSupposedMessageType());
        this.debugOutput("(traceComm.supposed)->msglength: " + event.getSupposedMessageLength());
        this.debugOutput("");
        this.debugOutput("(traceComm.accepted)->partner: " + event.getAcceptedPartnerProcess());
        this.debugOutput("(traceComm.accepted)->msgtype: " + event.getAcceptedMessageType());
        this.debugOutput("(traceComm.accepted)->msglength: " + event.getAcceptedMessageLength());
        this.debugOutput("");
        this.debugOutput("traceTime.log: " + event.getLogicalClock());
        this.debugOutput("traceTime.partnerLog: " + event.getPartnerLogicalClock());
        this.debugOutput("traceTime.timeStart: " + event.getPhysicalStartClock());
        this.debugOutput("traceTime.timeStop: " + event.getPhysicalStopClock());
        this.debugOutput("");
        this.debugOutput("traceExt.line: " + event.getSourceLineNumber());
        this.debugOutput("traceExt.file: " + event.getSourceFilename());
    }

    void readHeader() throws IOException {
        this.version = this.dataInputStream.readInt();
        byte statusByte = this.dataInputStream.readByte();
        boolean bl = this.isTrcBigEndian = (statusByte & trcLittleEndian) == 0;
        if (!this.isTrcBigEndian) {
            this.version = Integer.reverseBytes(this.version);
        }
        this.traceAmount = statusByte & trcTotal;
        this.source = (statusByte & trcWith) != 0;
        this.level = statusByte & trcTraps;
        this.dataAmount = statusByte & trcMaximum;
        this.multiprocessor = statusByte & trcPARSYTEC;
        byte[] filenameArray = new byte[this.readInt()];
        this.dataInputStream.read(filenameArray);
        this.filename = new String(filenameArray);
        byte[] argumentsArray = new byte[this.readInt()];
        this.dataInputStream.read(argumentsArray);
        this.arguments = new String(argumentsArray);
        this.monStrat = this.readInt();
        this.monPModel = this.readInt();
        this.monStor = this.readInt();
        this.monError = this.readInt();
        this.monFlush = this.readInt();
        this.monBuffer = this.readInt();
        this.runTimeStart = this.readLong();
    }

    private Event readEvent() throws IOException {
        Event event = null;
        byte fileByte = 0;
        fileByte = this.dataInputStream.readByte();
        int traceType = fileByte & ~trcTRUE;
        if (traceType == trcRecv || traceType == trcSend || traceType == trcTest) {
            event = this.readReceiveSendTestEvent(traceType);
        } else if (traceType == trcSourceLine) {
            this.readSourceEvent();
            event = this.readEvent();
        } else if (traceType == trcOthers) {
            Activator.logMessage(2, "unimplemented event type: trcOthers");
        } else if (traceType == trcTrace) {
            event = this.readTraceEvent();
        } else {
            Activator.logMessage(4, "unknown event type");
        }
        return event;
    }

    private Event readReceiveSendTestEvent(int traceType) throws IOException {
        ++this.previousLogicalClock;
        this.setMaximumLogicalClock(this.previousLogicalClock);
        Event event = this.supportsVectorClocks ? new VecEvent(this.previousLogicalClock, this) : new Event(this.previousLogicalClock, this);
        event.setLamportClock(-1);
        if (this.supportsVectorClocks) {
            ((VecEvent)event).setVectorClock(this.initialVectorClock);
        }
        event.setPartnerLamportClock(-1);
        event.setType(this.getEventType(traceType));
        int blocking = traceType & trcTRUE;
        event.setBlocking(blocking);
        event.setSubType(this.dataInputStream.readUnsignedByte());
        if (this.source) {
            event.setSourceFilenameIndex(this.sourceFilenameIndex);
            event.setSourceLineNumber(this.readInt());
            if (this.ignoreCounts.get(event.getSourceLineNumber()) != null) {
                event.setIgnoreCount(this.ignoreCounts.get(event.getSourceLineNumber()) + 1);
                this.ignoreCounts.put(event.getSourceLineNumber(), event.getIgnoreCount());
            } else {
                this.ignoreCounts.put(event.getSourceLineNumber(), 0);
                event.setIgnoreCount(0);
            }
            this.dataInputStream.skipBytes(1);
        }
        if (this.dataAmount == trcMedium || this.dataAmount == trcMaximum) {
            event.setPhysicalStartClock(this.readInt());
        }
        if (this.dataAmount == trcMaximum) {
            event.setSupposedPartnerProcess(this.readInt());
            event.setSupposedMessageType(this.readInt());
            event.setSupposedMessageLength(this.readInt());
        }
        event.setAcceptedPartnerProcess(this.readInt());
        event.setAcceptedMessageType(this.readInt());
        event.setAcceptedMessageLength(this.readInt());
        this.readInt();
        event.setPartnerLogicalClock(this.readInt());
        if (this.dataAmount == trcMaximum) {
            event.setPhysicalStopClock(this.readInt());
        }
        return event;
    }

    private void readSourceEvent() throws IOException {
        int len = this.dataInputStream.readUnsignedByte();
        byte[] srcfile = new byte[len];
        this.dataInputStream.read(srcfile);
        String sourceFilename = new String(srcfile);
        this.sourceFilenameIndex = this.addSourceFilename(sourceFilename);
    }

    private Event readTraceEvent() throws IOException {
        Event event = null;
        byte subtype = this.dataInputStream.readByte();
        if (subtype == trcTVarInsp) {
            Activator.logMessage(2, "subtype trcTVarInsp not supported");
        } else if (subtype == trcTFlush) {
            Activator.logMessage(2, "subtype trcTFlush not supported");
        } else if (subtype == trcTOnOff) {
            event = this.readEventSubTypeTOnOff();
        } else if (subtype == trcTTimer) {
            Activator.logMessage(2, "subtype trcTTimer not supported");
        } else if (subtype == trcTMsgQueue) {
            Activator.logMessage(2, "subtype trcTMsgQueue not supported");
        } else if (subtype == trcTTestLoop) {
            Activator.logMessage(2, "subtype trcTTestLoop not supported");
        } else if (subtype == trcTArrInsp) {
            event = this.readEventSubTypeTArrInsp();
        }
        return event;
    }

    private Event readEventSubTypeTOnOff() throws IOException {
        ++this.previousLogicalClock;
        this.setMaximumLogicalClock(this.previousLogicalClock);
        Event event = this.supportsVectorClocks ? new VecEvent(this.previousLogicalClock, this) : new Event(this.previousLogicalClock, this);
        event.setLamportClock(-1);
        if (this.supportsVectorClocks) {
            ((VecEvent)event).setVectorClock(this.initialVectorClock);
        }
        event.setPartnerLamportClock(-1);
        event.setType(EventType.OTHER);
        event.setAcceptedPartnerProcess(this.processId);
        if (this.source) {
            this.readInt();
            this.dataInputStream.readByte();
        }
        if (this.dataAmount == trcMedium || this.dataAmount == trcMaximum) {
            this.readInt();
        }
        this.dataInputStream.skipBytes(5);
        this.readInt();
        this.readInt();
        this.readInt();
        this.dataInputStream.readUnsignedByte();
        this.dataInputStream.skip(4L);
        return event;
    }

    private Event readEventSubTypeTArrInsp() throws IOException {
        ++this.previousLogicalClock;
        ArrayEvent event = new ArrayEvent(this.previousLogicalClock, this);
        event.setLamportClock(-1);
        event.setPartnerLamportClock(-1);
        event.setType(EventType.OTHER);
        event.setAcceptedPartnerProcess(this.processId);
        if (this.source) {
            event.setSourceLineNumber(this.readInt());
            this.dataInputStream.skipBytes(1);
        }
        if (this.dataAmount == trcMedium || this.dataAmount == trcMaximum) {
            event.setPhysicalStartClock(this.readInt());
        }
        this.dataInputStream.skipBytes(5);
        this.readInt();
        this.readInt();
        event.setPhysicalStopClock(this.readInt());
        this.dataInputStream.readUnsignedByte();
        this.readInt();
        int numDims = this.readInt();
        this.readInt();
        Vector<Integer> arrSize = new Vector<Integer>();
        int v = 0;
        while (v < numDims) {
            arrSize.add(this.readInt());
            ++v;
        }
        Vector<Integer> paSize = new Vector<Integer>();
        int v2 = 0;
        while (v2 < numDims) {
            paSize.add(this.readInt());
            ++v2;
        }
        Vector<Integer> dist = new Vector<Integer>();
        int v3 = 0;
        while (v3 < numDims) {
            dist.add(this.readInt());
            ++v3;
        }
        Vector<Integer> remainder = new Vector<Integer>();
        int v4 = 0;
        while (v4 < numDims) {
            remainder.add(this.readInt());
            ++v4;
        }
        StringBuffer test = new StringBuffer();
        char b = '\u0000';
        do {
            b = (char)this.dataInputStream.readByte();
            test.append(b);
        } while (b != '\u0000');
        StringBuffer test2 = new StringBuffer();
        do {
            b = (char)this.dataInputStream.readByte();
            test2.append(b);
        } while (b != '\u0000');
        return event;
    }

    private EventType getEventType(int type) {
        EventType evType = null;
        if (type == 1) {
            evType = EventType.RECV;
        } else if (type == 2) {
            evType = EventType.SEND;
        } else if (type == 3) {
            evType = EventType.TEST;
        } else if (type == 4) {
            evType = EventType.OTHER;
        }
        return evType;
    }
}

