/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.eventgraph.tracereader.otf;

import eu.geclipse.eventgraph.tracereader.otf.OTFReader;
import eu.geclipse.eventgraph.tracereader.otf.OTFUtils;
import eu.geclipse.eventgraph.tracereader.otf.Process;
import eu.geclipse.traceview.EventType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.InflaterInputStream;

class OTFStreamReader
extends OTFUtils {
    private BufferedReader input;
    private int timestamp = 0;
    private int processNr;
    private OTFReader trace;

    OTFStreamReader(File file, OTFReader trace) throws IOException {
        this.trace = trace;
        if (file.exists()) {
            this.input = new BufferedReader(new FileReader(file));
        } else {
            File zFile = new File(file.getParentFile(), String.valueOf(file.getName()) + ".z");
            this.input = new BufferedReader(new InputStreamReader(new InflaterInputStream(new FileInputStream(zFile))));
        }
        while ((this.line = this.input.readLine()) != null) {
            this.lineIdx = 0;
            char ch = this.line.charAt(0);
            if (Character.isDigit((int)ch) || Character.isLowerCase((int)ch)) {
                this.readTimestamp();
                continue;
            }
            if (ch == '*') {
                ++this.lineIdx;
                this.readProcessNr();
                continue;
            }
            if (ch == 'S') {
                ++this.lineIdx;
                this.readSend();
                continue;
            }
            if (ch != 'R') continue;
            ++this.lineIdx;
            this.readRecv();
        }
    }

    private void readRecv() throws IOException {
        int otfPartnerId = this.readNumber();
        int partnerId = this.trace.getProcessIdForOTFIndex(otfPartnerId);
        int processId = this.trace.getProcessIdForOTFIndex(this.processNr);
        ((Process)this.trace.getProcess(processId)).appendEvent(EventType.RECV, partnerId, this.timestamp);
    }

    private void readSend() throws IOException {
        int otfPartnerId = this.readNumber();
        int partnerId = this.trace.getProcessIdForOTFIndex(otfPartnerId);
        int processId = this.trace.getProcessIdForOTFIndex(this.processNr);
        ((Process)this.trace.getProcess(processId)).appendEvent(EventType.SEND, partnerId, this.timestamp);
    }

    private void readProcessNr() {
        this.processNr = this.readNumber();
    }

    private void readTimestamp() {
        this.timestamp = this.readNumber();
    }
}

