/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.internal.AbstractGraphVisualization;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.LineType;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class AbstractGraphPaintListener
implements PaintListener {
    protected static final int leftRulerWidth = 25;
    protected static final int bottomRulerWidth = 25;
    protected static final int leftMargin = 30;
    protected static final int bottomMargin = 30;
    protected static final int arc = 6;
    public IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            AbstractGraphPaintListener.this.handleProperyChanged(event);
        }
    };
    protected ScrollBar horizontalScrollBar;
    protected ScrollBar verticalScrollBar;
    protected int fromProcessLine = 0;
    protected int toProcessLine = 0;
    protected int hSpace = 6;
    protected int vSpace = 6;
    protected int yOffset;
    protected int eventSize = 2;
    protected int fontsize = 8;
    protected int width;
    protected int height;
    protected Color selectionColor;
    protected Color line1;
    protected Color line5;
    protected Color line10;
    protected boolean antialiasing;
    protected GC gc;
    protected AbstractGraphVisualization eventGraph;
    protected Font smallFont;
    protected int numProc;

    protected AbstractGraphPaintListener(AbstractGraphVisualization eventGraph) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.listener);
        this.eventGraph = eventGraph;
        this.updatePropertiesFromPreferences();
        this.setHorizontal(0);
        this.setVertical(0);
        this.line1 = new Color((Device)Display.getDefault(), new RGB(196, 196, 196));
        this.line5 = new Color((Device)Display.getDefault(), new RGB(128, 128, 128));
        this.line10 = new Color((Device)Display.getDefault(), new RGB(64, 64, 64));
    }

    public void setVertical(int selection) {
        this.fromProcessLine = selection / this.vSpace;
        this.yOffset = selection % this.vSpace - this.vSpace / 2;
    }

    public abstract void setHorizontal(int var1);

    void updatePropertiesFromPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.antialiasing = store.getBoolean("antiAliasingPreference");
        this.selectionColor = new Color((Device)this.eventGraph.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"selectionColorPreference"));
    }

    protected void handleProperyChanged(PropertyChangeEvent event) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (event.getProperty().equals("antiAliasingPreference")) {
            this.antialiasing = event.getNewValue() instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)event.getNewValue();
            this.eventGraph.redraw();
        } else if (event.getProperty().equals("selectionColorPreference")) {
            this.selectionColor.dispose();
            this.selectionColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)event.getProperty()));
            this.eventGraph.redraw();
        }
    }

    public void setFont(Font font) {
        FontData fontData = font.getFontData()[0];
        fontData.setHeight(this.fontsize);
        fontData.setStyle(0);
        this.smallFont = new Font(font.getDevice(), fontData);
    }

    protected void drawVRulerWithMovingLine(GC rulerGC, int line, int y) {
        rulerGC.setForeground(rulerGC.getDevice().getSystemColor(2));
        rulerGC.setBackground(rulerGC.getDevice().getSystemColor(1));
        rulerGC.fillRoundRectangle(0, 0, 25, this.height - 30, 6, 6);
        rulerGC.drawRoundRectangle(0, 0, 25, this.height - 30, 6, 6);
        this.drawVRuler(rulerGC, line);
        rulerGC.drawLine(20, y, 22, y);
        String text = this.getLabelForLine(line);
        rulerGC.drawText(text, 3, y - 7);
    }

    protected void drawVRuler(GC rulerGC, int lineToSkip) {
        rulerGC.setForeground(rulerGC.getDevice().getSystemColor(2));
        rulerGC.setFont(this.smallFont);
        rulerGC.setClipping(1, 1, 24, this.height - 31);
        int i = this.fromProcessLine;
        int y = 0 - this.yOffset;
        while (i < this.toProcessLine) {
            if (i != lineToSkip) {
                if (this.vSpace > 8 || i % 2 == 0) {
                    String text = this.getLabelForLine(i);
                    rulerGC.drawText(text, 3, y - 7 + this.eventSize / 2);
                }
                rulerGC.drawLine(20, y + this.eventSize / 2, 22, y + this.eventSize / 2);
            }
            ++i;
            y += this.vSpace;
        }
    }

    protected String getLabelForLine(int procLine) {
        SortedSet<Integer> procSet = this.eventGraph.getLineToProcessMapping().get(procLine);
        StringBuilder sb = new StringBuilder();
        Iterator it = procSet.iterator();
        if (it.hasNext()) {
            int procNr = (Integer)it.next();
            boolean hidden = this.eventGraph.hideProcess[procNr];
            if (hidden) {
                sb.append('(');
            }
            sb.append(procNr);
            if (hidden) {
                sb.append(')');
            }
            while (it.hasNext()) {
                procNr = (Integer)it.next();
                hidden = this.eventGraph.hideProcess[procNr];
                sb.append(',');
                if (hidden) {
                    sb.append('(');
                }
                sb.append(procNr);
                if (!hidden) continue;
                sb.append(')');
            }
        } else {
            sb.append('X');
        }
        return sb.toString();
    }

    protected void drawGridHLines() {
        this.gc.setForeground(this.line1);
        LineType hLines = this.eventGraph.getHLines();
        if (hLines != LineType.Lines_None) {
            int i = this.fromProcessLine;
            int y = 0 - this.yOffset + this.eventSize / 2;
            while (i < this.toProcessLine) {
                if (i % 10 == 0) {
                    this.gc.setForeground(this.line10);
                    this.gc.drawLine(31, y, this.width - 1, y);
                    this.gc.setForeground(this.line1);
                } else if ((hLines == LineType.Lines_5 || hLines == LineType.Lines_1) && i % 5 == 0) {
                    this.gc.setForeground(this.line5);
                    this.gc.drawLine(31, y, this.width - 1, y);
                    this.gc.setForeground(this.line5);
                } else if (hLines == LineType.Lines_1) {
                    this.gc.drawLine(31, y, this.width - 1, y);
                }
                ++i;
                y += this.vSpace;
            }
        }
    }

    protected void drawBackground() {
        this.gc.setForeground(this.gc.getDevice().getSystemColor(18));
        this.gc.setBackground(this.gc.getDevice().getSystemColor(1));
        this.gc.fillRectangle(30, 0, this.width - 30, this.height - 30);
        this.gc.drawRectangle(30, 0, this.width - 30, this.height - 30);
        this.gc.fillRoundRectangle(30, this.height - 25, this.width - 30, 25, 6, 6);
        this.gc.drawRoundRectangle(30, this.height - 25, this.width - 30, 25, 6, 6);
        this.gc.fillRoundRectangle(0, 0, 25, this.height - 30, 6, 6);
        this.gc.drawRoundRectangle(0, 0, 25, this.height - 30, 6, 6);
    }

    protected void connection(int x1, int y1, int x2, int y2, boolean spacing) {
        long xv = x2 - x1;
        long yv = y2 - y1;
        float c = (float)Math.sqrt(xv * xv + yv * yv);
        int ex = Math.round((float)xv / c * (float)this.getArrowSize());
        int ey = Math.round((float)yv / c * (float)this.getArrowSize());
        int ox = spacing ? ex : 0;
        int oy = spacing ? ey : 0;
        this.gc.drawLine(x2 - ox, y2 - oy, x1 + ox, y1 + oy);
        int[] arrowhead = new int[]{x2 - ox, y2 - oy, x2 - ox - ex - ey, y2 - oy - ey + ex, x2 - ox - ex + ey, y2 - oy - ey - ex};
        this.gc.fillPolygon(arrowhead);
    }

    public abstract int getArrowSize();

    public void setHorizontalScrollBar(ScrollBar bar) {
        this.horizontalScrollBar = bar;
        this.horizontalScrollBar.setPageIncrement(this.hSpace);
        this.horizontalScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AbstractGraphPaintListener.this.handleHorizontalScrollBar();
            }
        });
    }

    public void setVerticalScrollBar(ScrollBar bar) {
        this.verticalScrollBar = bar;
        this.verticalScrollBar.setPageIncrement(this.vSpace);
        this.verticalScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AbstractGraphPaintListener.this.handleVerticalScrollBar();
            }
        });
    }

    protected void handleHorizontalScrollBar() {
        int selection = this.horizontalScrollBar.getSelection();
        this.setHorizontal(selection);
        this.eventGraph.redraw();
    }

    protected void handleVerticalScrollBar() {
        int selection = this.verticalScrollBar.getSelection();
        this.setVertical(selection);
        this.eventGraph.redraw();
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public int getHSpace() {
        return this.hSpace;
    }

    public int getVSpace() {
        return this.vSpace;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getFromProcessLine() {
        return this.fromProcessLine;
    }

    protected boolean procDrawingEnabled(int procId, boolean ignoreHide) {
        return (!this.eventGraph.hideProcess[procId] || ignoreHide) && this.eventGraph.getProcessToLineMapping()[procId] != -1;
    }

    protected boolean procDrawingEnabled(int procId) {
        return this.procDrawingEnabled(procId, false);
    }

    protected int getYPosForProcId(int procId) {
        int line = this.eventGraph.getProcessToLineMapping()[procId];
        return (line - this.fromProcessLine) * this.vSpace - this.yOffset + this.eventSize / 2;
    }

    public abstract void handleResize();

    public abstract void print(GC var1);

    public abstract void setTrace(ITrace var1);
}

