/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class GotoSourceAction
extends Action
implements IActionDelegate {
    private Object selectedObj;

    public void run(IAction action) {
        try {
            if (this.selectedObj instanceof ISourceLocation) {
                ISourceLocation sourceLocation = (ISourceLocation)this.selectedObj;
                if (sourceLocation.getSourceFilename() != null) {
                    IPath path = this.findPath(sourceLocation.getSourceFilename(), (IResource)ResourcesPlugin.getWorkspace().getRoot());
                    if (path == null) {
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("GotoSourceAction.errorTitle"), (String)Messages.getString("GotoSourceAction.fileNotInWorkspace"), (IStatus)new Status(4, "eu.geclipse.traceview", Messages.getString("GotoSourceAction.fileNotInWorkspace")));
                    } else {
                        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        if (editorPart instanceof ITextEditor) {
                            ITextEditor textEditor = (ITextEditor)editorPart;
                            IEditorInput input = editorPart.getEditorInput();
                            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
                            int offset = document.getLineInformation(sourceLocation.getSourceLineNumber() - 1).getOffset();
                            textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
                        }
                    }
                } else {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("GotoSourceAction.errorTitle"), (String)Messages.getString("GotoSourceAction.noSourceLocation"), (IStatus)new Status(4, "eu.geclipse.traceview", Messages.getString("GotoSourceAction.noSourceLocation")));
                }
            }
        }
        catch (PartInitException exception) {
            Activator.logException((Exception)((Object)exception));
        }
        catch (CoreException exception) {
            Activator.logException((Exception)((Object)exception));
        }
        catch (BadLocationException exception) {
            Activator.logException((Exception)((Object)exception));
        }
    }

    private IPath findPath(String filename, IResource searchPath) throws CoreException {
        IPath result = null;
        if (searchPath instanceof IContainer && ((IContainer)searchPath).isAccessible()) {
            IResource[] iResourceArray = ((IContainer)searchPath).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                result = resource.getName().equals(filename) ? resource.getLocation() : this.findPath(filename, resource);
                if (result != null) break;
                ++n2;
            }
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            this.selectedObj = structuredSelection.getFirstElement();
        }
    }
}

