/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.internal.EventMarkerEntry;
import eu.geclipse.traceview.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerOrderDialog
extends TitleAreaDialog {
    private List<EventMarkerEntry> initMarkerList;
    private List<EventMarkerEntry> newMarkerList;
    private Table table;
    private Button upButton;
    private Button downButton;

    public MarkerOrderDialog(Shell parentShell) {
        super(parentShell);
    }

    void setEventMarkerEntries(List<EventMarkerEntry> list) {
        this.initMarkerList = list;
    }

    List<EventMarkerEntry> getEventMarkerEntries() {
        return this.newMarkerList;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("MarkerOrderDialog.dialogTitle"));
        this.setMessage(Messages.getString("MarkerOrderDialog.dialogDesc"));
        this.getShell().setText(Messages.getString("MarkerOrderDialog.winTitle"));
        Composite comp = new Composite(parent, 4);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gData = new GridData(4, 4, true, true);
        gData.verticalSpan = 3;
        this.table = new Table(comp, 2848);
        this.table.setLayoutData((Object)gData);
        for (EventMarkerEntry item : this.initMarkerList) {
            this.getTableItem(item, this.table.getItemCount());
        }
        this.upButton = new Button(comp, 2048);
        this.upButton.setText(Messages.getString("MarkerOrderDialog.moveUp"));
        this.upButton.setEnabled(false);
        this.upButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MarkerOrderDialog.this.table.getSelectionIndex();
                EventMarkerEntry item = (EventMarkerEntry)MarkerOrderDialog.this.table.getItem(selectionIndex).getData();
                boolean selected = MarkerOrderDialog.this.table.getItem(selectionIndex).getChecked();
                MarkerOrderDialog.this.table.remove(selectionIndex);
                TableItem tableItem = MarkerOrderDialog.this.getTableItem(item, selectionIndex - 1);
                tableItem.setChecked(selected);
                MarkerOrderDialog.this.table.setSelection(selectionIndex - 1);
                MarkerOrderDialog.this.updateButtonState();
            }
        });
        this.downButton = new Button(comp, 2048);
        this.downButton.setText(Messages.getString("MarkerOrderDialog.moveDown"));
        this.downButton.setEnabled(false);
        this.downButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MarkerOrderDialog.this.table.getSelectionIndex();
                EventMarkerEntry item = (EventMarkerEntry)MarkerOrderDialog.this.table.getItem(selectionIndex).getData();
                boolean selected = MarkerOrderDialog.this.table.getItem(selectionIndex).getChecked();
                MarkerOrderDialog.this.table.remove(selectionIndex);
                TableItem tableItem = MarkerOrderDialog.this.getTableItem(item, selectionIndex + 1);
                tableItem.setChecked(selected);
                MarkerOrderDialog.this.table.setSelection(selectionIndex + 1);
                MarkerOrderDialog.this.updateButtonState();
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerOrderDialog.this.updateButtonState();
            }
        });
        return comp;
    }

    private void updateButtonState() {
        this.upButton.setEnabled(this.table.getSelectionIndex() > 0);
        this.downButton.setEnabled(this.table.getSelectionIndex() < this.table.getItemCount() - 1);
    }

    private TableItem getTableItem(EventMarkerEntry entry, int index) {
        TableItem tableItem = new TableItem(this.table, 0, index);
        tableItem.setText(entry.label);
        tableItem.setData((Object)entry);
        tableItem.setChecked(entry.enabled);
        return tableItem;
    }

    protected void okPressed() {
        this.newMarkerList = new ArrayList<EventMarkerEntry>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EventMarkerEntry entry = (EventMarkerEntry)item.getData();
            entry.enabled = item.getChecked();
            this.newMarkerList.add(entry);
            ++n2;
        }
        super.okPressed();
    }
}

