/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.utils.AbstractEventMarker;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SelectionPartnerMarker
extends AbstractEventMarker {
    Set<IEvent> selectedEvents = new HashSet<IEvent>();
    Set<IEvent> partnerEvents = new HashSet<IEvent>();

    public SelectionPartnerMarker() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener("eu.geclipse.traceview.views.TraceView", new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                StructuredSelection sSel = (StructuredSelection)selection;
                SelectionPartnerMarker.this.selectedEvents = new HashSet<IEvent>();
                SelectionPartnerMarker.this.partnerEvents = new HashSet<IEvent>();
                for (Object obj : sSel.toList()) {
                    if (!(obj instanceof IEvent)) continue;
                    IEvent event = (IEvent)obj;
                    SelectionPartnerMarker.this.selectedEvents.add(event);
                    if (event.getPartnerEvent() == null) continue;
                    SelectionPartnerMarker.this.partnerEvents.add(event.getPartnerEvent());
                }
            }
        });
    }

    public Color getBackgroundColor(int type) {
        return Display.getDefault().getSystemColor(15);
    }

    public Color getForegroundColor(int type) {
        return Display.getDefault().getSystemColor(2);
    }

    public int mark(IEvent event) {
        int result = 0;
        for (IEvent parEvent : this.partnerEvents) {
            if (!parEvent.equals(event)) continue;
            result = 4;
            break;
        }
        if (result == 0 && event.getPartnerEvent() != null && this.selectedEvents.contains(event.getPartnerEvent())) {
            result = 4;
        }
        return result;
    }
}

