/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.logicalgraph;

import eu.geclipse.traceview.ILamportTrace;
import eu.geclipse.traceview.internal.AbstractGraphVisualization;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.logicalgraph.LogicalGraphMouseAdapter;
import eu.geclipse.traceview.logicalgraph.LogicalGraphPaintListener;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;

public class LogicalGraph
extends AbstractGraphVisualization {
    private Action zoomin;
    private Action zoomout;
    private LogicalGraphPaintListener eventGraphPaintListener = new LogicalGraphPaintListener(this);

    public LogicalGraph(Composite parent, int style, IViewSite viewSite, ILamportTrace trace) {
        super(parent, style, viewSite, trace);
        this.registerPaintListener(this.eventGraphPaintListener);
        this.registerMouseListener(new LogicalGraphMouseAdapter(this));
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.keyCode) {
                    case 43: {
                        LogicalGraph.this.zoomIn();
                        break;
                    }
                    case 45: {
                        LogicalGraph.this.zoomOut();
                    }
                }
            }
        });
    }

    public LogicalGraphPaintListener getEventGraphPaintListener() {
        return this.eventGraphPaintListener;
    }

    protected int getZoomFactor() {
        return this.eventGraphPaintListener.getZoomfactor();
    }

    public IContributionItem[] getToolBarItems() {
        IContributionItem[] superItems = super.getToolBarItems();
        Action hLinesAction = new Action(Messages.getString("LogicalGraph.VLineStyle"), Activator.getImageDescriptor("icons/vertical.gif")){

            public void run() {
                LogicalGraph.this.changeLineStyle(-1);
            }
        };
        Action vLinesAction = new Action(Messages.getString("LogicalGraph.HLineStyle"), Activator.getImageDescriptor("icons/horizontal.gif")){

            public void run() {
                LogicalGraph.this.changeLineStyle(1);
            }
        };
        this.zoomin = new Action(Messages.getString("LogicalGraph.ZoomIn"), Activator.getImageDescriptor("icons/zin.gif")){

            public void run() {
                LogicalGraph.this.zoomIn();
            }
        };
        this.zoomout = new Action(Messages.getString("LogicalGraph.ZoomOut"), Activator.getImageDescriptor("icons/zout.gif")){

            public void run() {
                LogicalGraph.this.zoomOut();
            }
        };
        this.zoomout.setEnabled(false);
        Vector<Object> items = new Vector<Object>();
        IContributionItem[] iContributionItemArray = superItems;
        int n = superItems.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            items.add(item);
            ++n2;
        }
        items.add(new ActionContributionItem((IAction)this.zoomin));
        items.add(new ActionContributionItem((IAction)this.zoomout));
        items.add(new ActionContributionItem((IAction)hLinesAction));
        items.add(new ActionContributionItem((IAction)vLinesAction));
        items.add(new Separator());
        return items.toArray(new IContributionItem[items.size()]);
    }

    void zoomIn() {
        int zoom = this.getZoomFactor();
        if (zoom < 8) {
            this.eventGraphPaintListener.setZoomfactor(++zoom);
            this.redraw();
        }
        this.updateZoomButtons();
    }

    void zoomOut() {
        int zoom = this.getZoomFactor();
        if (zoom > 1) {
            this.eventGraphPaintListener.setZoomfactor(--zoom);
            this.redraw();
        }
        this.updateZoomButtons();
    }

    void updateZoomButtons() {
        int zoom = this.getZoomFactor();
        this.zoomout.setEnabled(zoom != 1);
        this.zoomin.setEnabled(zoom != 8);
    }
}

