/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.logicalgraph;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IEventMarker;
import eu.geclipse.traceview.ILamportEvent;
import eu.geclipse.traceview.ILamportProcess;
import eu.geclipse.traceview.ILamportTrace;
import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.internal.AbstractGraphPaintListener;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.LineType;
import eu.geclipse.traceview.logicalgraph.LogicalGraph;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;

class LogicalGraphPaintListener
extends AbstractGraphPaintListener {
    private int zoomfactor = 1;
    private int xOffset;
    private int fromClock = 0;
    private int toClock = 0;
    private int maxLamport;
    private ILamportTrace trace;
    private boolean scrollBarsInitialized = false;

    LogicalGraphPaintListener(LogicalGraph eventGraph) {
        super(eventGraph);
    }

    protected int getZoomfactor() {
        return this.zoomfactor;
    }

    public void handleResize() {
        this.setScrollBarSizes();
    }

    protected void setScrollBarSizes() {
        int selection;
        int clockDiff = Math.min((int)(((double)this.maxLamport + 1.5 - (double)this.fromClock) * (double)this.hSpace), this.width - 31 + this.eventSize);
        int processDiff = Math.min((int)(((double)(this.numProc - this.fromProcessLine) + 0.5) * (double)this.hSpace), this.height - 31 + this.eventSize);
        if (this.horizontalScrollBar != null) {
            selection = this.horizontalScrollBar.getSelection();
            this.horizontalScrollBar.setValues(selection, 0, (int)((double)this.hSpace * ((double)this.maxLamport + 1.5)), clockDiff, 1, this.hSpace);
        }
        if (this.verticalScrollBar != null) {
            selection = this.verticalScrollBar.getSelection();
            this.verticalScrollBar.setValues(selection, 0, (int)((double)this.vSpace * ((double)this.numProc + 0.5)), processDiff, 1, this.vSpace);
        }
    }

    private void drawLeftRightTopBottom() {
        int from = Math.max(this.fromClock - 100, 0);
        int i = 0;
        while (i < this.numProc) {
            ILamportEvent[] events;
            ILamportEvent[] iLamportEventArray = events = ((ILamportProcess)this.eventGraph.getTrace().getProcess(i)).getEventsByLamportClock(from, this.fromClock - 1);
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                ILamportEvent event = iLamportEventArray[n2];
                if (event.getType() == EventType.SEND && event.getPartnerLamportClock() >= this.fromClock) {
                    Color messageColor = null;
                    for (IEventMarker eventmarker : this.eventGraph.getEventMarkers()) {
                        Color newColor;
                        if (eventmarker.mark(event) == 0 || (newColor = eventmarker.getMessageColor()) == null) continue;
                        messageColor = newColor;
                    }
                    if (messageColor != null) {
                        this.gc.setBackground(messageColor);
                        this.gc.setForeground(messageColor);
                        this.drawConnection(event);
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private void drawGraphBackground() {
        int i = this.fromProcessLine;
        while (i < this.toProcessLine) {
            ILamportProcess process = (ILamportProcess)this.eventGraph.getTrace().getProcess(i);
            if (this.procDrawingEnabled(process.getProcessId())) {
                ILamportEvent[] events;
                ILamportEvent[] iLamportEventArray = events = process.getEventsByLamportClock(this.fromClock, this.toClock);
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    ILamportEvent event = iLamportEventArray[n2];
                    Color color = null;
                    IEventMarker lastMarker = null;
                    for (IEventMarker eventmarker : this.eventGraph.getEventMarkers()) {
                        Color newColor;
                        int mark = eventmarker.mark(event);
                        if (mark == 0 || (newColor = eventmarker.getCanvasBackgroundColor()) == null) continue;
                        color = newColor;
                        lastMarker = eventmarker;
                    }
                    if (color != null) {
                        int bgWidth = this.hSpace;
                        ILamportEvent nextEvent = (ILamportEvent)event.getNextEvent();
                        if (nextEvent != null && lastMarker.mark(nextEvent) != 0 && color.equals((Object)lastMarker.getCanvasBackgroundColor())) {
                            bgWidth *= nextEvent.getLamportClock() - event.getLamportClock();
                        }
                        this.gc.setBackground(color);
                        int x = this.getXPosForClock(event.getLamportClock()) - this.hSpace / 2;
                        int y = this.getYPosForProcId(event.getProcessId()) - this.vSpace / 2;
                        this.gc.fillRectangle(x, y, bgWidth, this.vSpace);
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    private void drawGraph() {
        int i = 0;
        while (i < this.numProc) {
            try {
                ILamportProcess process = (ILamportProcess)this.eventGraph.getTrace().getProcess(i);
                if (this.procDrawingEnabled(process.getProcessId())) {
                    ILamportEvent[] events;
                    ILamportEvent[] iLamportEventArray = events = process.getEventsByLamportClock(this.fromClock, this.toClock);
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILamportEvent event = iLamportEventArray[n2];
                        int x = this.getXPosForClock(event.getLamportClock()) - this.eventSize / 2;
                        int y = this.getYPosForProcId(event.getProcessId()) - this.eventSize / 2;
                        this.drawEvent(event, x, y);
                        if (event.getType() == EventType.SEND || event.getType() == EventType.RECV) {
                            this.gc.setLineWidth(0);
                            this.gc.setLineStyle(1);
                            Color messageColor = null;
                            for (IEventMarker eventmarker : this.eventGraph.getEventMarkers()) {
                                Color newColor;
                                if (eventmarker.mark(event) == 0 || (newColor = eventmarker.getMessageColor()) == null) continue;
                                messageColor = newColor;
                            }
                            if (messageColor != null) {
                                this.gc.setBackground(messageColor);
                                this.gc.setForeground(messageColor);
                                this.drawConnection(event);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                Activator.logException(exception);
            }
            ++i;
        }
        this.gc.setLineStyle(1);
        this.gc.setLineWidth(0);
    }

    void drawEvent(ILamportEvent event, int x, int y) {
        int[] markTypes = new int[]{32, 16, 4, 2, 8};
        for (IEventMarker eventmarker : this.eventGraph.getEventMarkers()) {
            int mark = eventmarker.mark(event);
            if ((mark & 0x3F) == 0) continue;
            int markType = 0;
            int i = 0;
            while (i < markTypes.length) {
                markType = markTypes[i];
                if ((mark & markType) != 0) break;
                ++i;
            }
            int[] poly = null;
            this.gc.setLineStyle(eventmarker.getLineStyle(markType));
            this.gc.setLineWidth(eventmarker.getLineWidth(markType));
            if (markType == 32) {
                poly = new int[]{x + this.eventSize / 2, y, x, y + this.eventSize / 2, x + this.eventSize / 2, y + this.eventSize, x + this.eventSize, y + this.eventSize / 2, x + this.eventSize / 2, y};
            } else if (markType == 16) {
                poly = new int[]{x + this.eventSize / 2, y, x, y + this.eventSize, x + this.eventSize, y + this.eventSize, x + this.eventSize / 2, y};
            }
            Color color = eventmarker.getBackgroundColor(markType);
            if (color != null) {
                this.gc.setBackground(color);
                if (poly != null) {
                    this.gc.fillPolygon(poly);
                } else if (markType == 4) {
                    this.gc.fillOval(x, y, this.eventSize, this.eventSize);
                } else if (markType == 2) {
                    this.gc.fillRectangle(x, y, this.eventSize, this.eventSize);
                }
            }
            if ((color = eventmarker.getForegroundColor(markType)) == null) continue;
            this.gc.setForeground(color);
            if (poly != null) {
                this.gc.drawPolygon(poly);
                continue;
            }
            if (markType == 4) {
                this.gc.drawOval(x, y, this.eventSize, this.eventSize);
                continue;
            }
            if (markType == 2) {
                this.gc.drawRectangle(x, y, this.eventSize, this.eventSize);
                continue;
            }
            if (markType != 8) continue;
            this.gc.drawLine(x, y, x + this.eventSize, y + this.eventSize);
            this.gc.drawLine(x, y + this.eventSize, x + this.eventSize, y);
        }
    }

    private void drawHRuler() {
        this.gc.setForeground(this.gc.getDevice().getSystemColor(2));
        this.gc.setFont(this.smallFont);
        int y = this.height - 22;
        this.gc.setClipping(31, this.height - 26, this.width - 31, 26);
        int i = this.fromClock;
        while (i <= this.toClock) {
            int x = this.getXPosForClock(i);
            if (i % 10 == 0) {
                this.gc.drawLine(x, y, x, y + 7);
            } else if (i % 5 == 0) {
                this.gc.drawLine(x, y, x, y + 5);
            } else {
                this.gc.drawLine(x, y, x, y + 3);
            }
            if (this.zoomfactor > 6) {
                this.gc.drawText(Integer.toString(i), x - this.gc.textExtent((String)Integer.toString((int)i)).x / 2, y + 9);
            } else if (this.zoomfactor > 3 && i % 2 == 0) {
                this.gc.drawText(Integer.toString(i), x - this.gc.textExtent((String)Integer.toString((int)i)).x / 2, y + 9);
            } else if (i % 5 == 0 && this.zoomfactor < 4 && this.zoomfactor > 1) {
                this.gc.drawText(Integer.toString(i), x - this.gc.textExtent((String)Integer.toString((int)i)).x / 2, y + 9);
            } else if (i % 10 == 0 && this.zoomfactor == 1) {
                this.gc.drawText(Integer.toString(i), x - this.gc.textExtent((String)Integer.toString((int)i)).x / 2, y + 9);
            }
            ++i;
        }
    }

    private void drawGridVLines() {
        this.gc.setForeground(this.line1);
        LineType vLines = this.eventGraph.getVLines();
        if (vLines != LineType.Lines_None) {
            int i = this.fromClock;
            while (i <= this.toClock) {
                int x = this.getXPosForClock(i);
                if (i % 10 == 0) {
                    this.gc.setForeground(this.line10);
                    this.gc.drawLine(x, 1, x, this.height - 31);
                    this.gc.setForeground(this.line1);
                } else if ((vLines == LineType.Lines_5 || vLines == LineType.Lines_1) && i % 5 == 0) {
                    this.gc.setForeground(this.line5);
                    this.gc.drawLine(x, 1, x, this.height - 31);
                    this.gc.setForeground(this.line1);
                } else if (vLines == LineType.Lines_1) {
                    this.gc.drawLine(x, 1, x, this.height - 31);
                }
                ++i;
            }
        }
    }

    public void paintControl(PaintEvent e) {
        this.gc = e.gc;
        if (this.antialiasing) {
            this.gc.setAntialias(1);
        }
        this.height = this.eventGraph.getClientArea().height - 1;
        this.width = this.eventGraph.getClientArea().width - 1;
        this.drawBackground();
        if (this.eventGraph.getTrace() != null) {
            this.toClock = Math.min(this.maxLamport, this.fromClock + (this.width - 31 + this.eventSize) / this.hSpace + 2);
            this.toProcessLine = Math.min(this.eventGraph.getLineToProcessMapping().size(), this.fromProcessLine + (this.height - 31 + this.eventSize) / this.vSpace + 2);
            this.drawVRuler(this.gc, -1);
            this.drawHRuler();
            this.gc.setClipping(31, 1, this.width - 31, this.height - 31);
            this.drawGraphBackground();
            this.drawGridHLines();
            this.drawGridVLines();
            this.drawSelection();
            this.drawGraph();
            this.drawLeftRightTopBottom();
            if (!this.scrollBarsInitialized) {
                this.setScrollBarSizes();
                this.scrollBarsInitialized = true;
            }
        }
    }

    void drawSelection() {
        ISelection selection = null;
        try {
            selection = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider().getSelection();
        }
        catch (Exception exception) {}
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object obj : structuredSelection.toList()) {
                IProcess process;
                int y;
                int x;
                if (obj instanceof ILamportEvent) {
                    ILamportEvent event = (ILamportEvent)obj;
                    if (event.getProcess().getTrace() != this.trace || this.fromClock > event.getLamportClock() || event.getLamportClock() > this.toClock || !this.procDrawingEnabled(event.getProcessId(), true)) continue;
                    x = this.getXPosForClock(event.getLamportClock()) - this.eventSize / 2;
                    y = this.getYPosForProcId(event.getProcessId()) - this.eventSize / 2;
                    this.gc.setForeground(this.selectionColor);
                    this.gc.setBackground(this.selectionColor);
                    this.gc.fillOval(x - this.eventSize / 4, y - this.eventSize / 4, this.eventSize + this.eventSize / 2, this.eventSize + this.eventSize / 2);
                    continue;
                }
                if (!(obj instanceof IProcess) || (process = (IProcess)obj).getTrace() != this.trace || !this.procDrawingEnabled(process.getProcessId(), true)) continue;
                x = 0;
                y = this.getYPosForProcId(process.getProcessId()) - this.eventSize / 2;
                this.gc.setForeground(this.selectionColor);
                this.gc.setBackground(this.selectionColor);
                this.gc.fillRectangle(x, y + this.eventSize / 4, this.width, this.eventSize / 2);
            }
        }
    }

    public void setHorizontal(int selection) {
        this.fromClock = selection / this.hSpace;
        this.xOffset = selection % this.hSpace - this.hSpace / 2;
    }

    public int getDiff() {
        return this.toClock - this.fromClock;
    }

    public void setTrace(ITrace trace) {
        this.trace = (ILamportTrace)trace;
        if (this.trace != null) {
            this.maxLamport = this.trace.getMaximumLamportClock();
            this.numProc = this.trace.getNumberOfProcesses();
            this.setHorizontal(0);
            this.setVertical(0);
            this.scrollBarsInitialized = false;
        }
    }

    protected void setZoomfactor(int zoomfactor) {
        int hsel = this.horizontalScrollBar.getSelection() / this.zoomfactor;
        int vsel = this.verticalScrollBar.getSelection() / this.zoomfactor;
        int hValue = this.horizontalScrollBar.getSelection() / this.hSpace;
        int vValue = this.verticalScrollBar.getSelection() / this.vSpace;
        this.hSpace = 6 * zoomfactor;
        this.vSpace = 6 * zoomfactor;
        this.eventSize = 2 * zoomfactor;
        this.zoomfactor = zoomfactor;
        this.horizontalScrollBar.setSelection(hValue * this.hSpace);
        this.verticalScrollBar.setSelection(vValue * this.vSpace);
        this.setScrollBarSizes();
        this.setHorizontal(hsel *= this.zoomfactor);
        this.setVertical(vsel *= this.zoomfactor);
    }

    public void print(GC gc2) {
        this.gc = gc2;
        this.gc.setLineAttributes(new LineAttributes(1.0f));
        this.drawVRuler(this.gc, -1);
        this.drawHRuler();
        this.gc.setClipping(31, 1, this.width - 31, this.height - 31);
        this.drawGridHLines();
        this.drawGridVLines();
        this.drawGraph();
    }

    public int getArrowSize() {
        return this.eventSize / 2;
    }

    private int getXPosForClock(int lamportClock) {
        return (lamportClock - this.fromClock) * this.hSpace + 30 - this.xOffset + this.eventSize / 2;
    }

    void drawConnection(ILamportEvent event) {
        if (event.getPartnerProcessId() != -1 && this.procDrawingEnabled(event.getProcessId()) && this.procDrawingEnabled(event.getPartnerProcessId())) {
            int x1 = this.getXPosForClock(event.getLamportClock());
            int y1 = this.getYPosForProcId(event.getProcessId());
            int x2 = this.getXPosForClock(event.getPartnerLamportClock());
            int y2 = this.getYPosForProcId(event.getPartnerProcessId());
            if (y1 == y2) {
                return;
            }
            if (event.getType() == EventType.SEND) {
                this.connection(x1, y1, x2, y2, true);
            } else {
                this.connection(x2, y2, x1, y1, true);
            }
        }
    }
}

