/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.physicalgraph;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.IPhysicalProcess;
import eu.geclipse.traceview.IPhysicalTrace;
import eu.geclipse.traceview.internal.AbstractGraphVisualization;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.physicalgraph.PhysicalGraphMouseAdapter;
import eu.geclipse.traceview.physicalgraph.PhysicalGraphPaintListener;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;

public class PhysicalGraph
extends AbstractGraphVisualization {
    private PhysicalGraphPaintListener eventGraphPaintListener = new PhysicalGraphPaintListener(this);

    public PhysicalGraph(Composite parent, int style, IViewSite viewSite, IPhysicalTrace trace) {
        super(parent, style, viewSite, trace);
        this.registerPaintListener(this.eventGraphPaintListener);
        this.registerMouseListener(new PhysicalGraphMouseAdapter(this));
    }

    public PhysicalGraphPaintListener getEventGraphPaintListener() {
        return this.eventGraphPaintListener;
    }

    protected int getVZoomFactor() {
        return this.eventGraphPaintListener.getVZoomfactor();
    }

    protected float getHZoomFactor() {
        return this.eventGraphPaintListener.getHZoomfactor();
    }

    protected void setHZoomFactor(float zoomfactor) {
        this.eventGraphPaintListener.setHZoomfactor(zoomfactor);
        this.redraw();
    }

    protected void setVZoomFactor(int zoomfactor) {
        this.eventGraphPaintListener.setVZoomfactor(zoomfactor);
        this.redraw();
    }

    protected void calcStartTimeOffset() {
        int i = 0;
        while (i < this.trace.getNumberOfProcesses()) {
            IPhysicalProcess proc = (IPhysicalProcess)this.trace.getProcess(i);
            int j = 0;
            while (j < Math.min(100, proc.getMaximumLogicalClock())) {
                IPhysicalEvent event = (IPhysicalEvent)proc.getEventByLogicalClock(j);
                if ((event.getType().equals((Object)EventType.SEND) || event.getType().equals((Object)EventType.RECV)) && event.getPartnerEvent() != null) {
                    int diff = event.getPhysicalStopClock() - event.getPartnerPhysicalStopClock();
                    if (event.getType() == EventType.RECV) {
                        diff *= -1;
                    }
                    if (diff > 0) {
                        IPhysicalProcess partnerProc = (IPhysicalProcess)this.trace.getProcess(event.getPartnerProcessId());
                        partnerProc.setStartTimeOffset(partnerProc.getStartTimeOffset() + diff);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void toggleMessageDrawing() {
        boolean drawMessages = this.eventGraphPaintListener.isDrawMessages();
        this.eventGraphPaintListener.setDrawMessages(!drawMessages);
    }

    public IContributionItem[] getToolBarItems() {
        IContributionItem[] superItems = super.getToolBarItems();
        Action vzoomin = new Action(Messages.getString("PhysicalGraph.VerticalZoomIn"), Activator.getImageDescriptor("icons/vertical_zoom_in.gif")){

            public void run() {
                int zoom = PhysicalGraph.this.getVZoomFactor();
                if (zoom < 20) {
                    PhysicalGraph.this.setVZoomFactor(++zoom);
                }
            }
        };
        Action vzoomout = new Action(Messages.getString("PhysicalGraph.VerticalZoomOut"), Activator.getImageDescriptor("icons/vertical_zoom_out.gif")){

            public void run() {
                int zoom = PhysicalGraph.this.getVZoomFactor();
                if (zoom > 1) {
                    PhysicalGraph.this.setVZoomFactor(--zoom);
                }
            }
        };
        Action hzoomin = new Action(Messages.getString("PhysicalGraph.HorizontalZoomIn"), Activator.getImageDescriptor("icons/horizontal_zoom_in.gif")){

            public void run() {
                float zoom = PhysicalGraph.this.getHZoomFactor();
                if (zoom < 1.0f) {
                    PhysicalGraph.this.setHZoomFactor(zoom * 2.0f);
                } else if (zoom < 20.0f) {
                    PhysicalGraph.this.setHZoomFactor(zoom += 1.0f);
                }
            }
        };
        Action hzoomout = new Action(Messages.getString("PhysicalGraph.HorizontalZoomOut"), Activator.getImageDescriptor("icons/horizontal_zoom_out.gif")){

            public void run() {
                float zoom = PhysicalGraph.this.getHZoomFactor();
                if (zoom > 1.0f) {
                    PhysicalGraph.this.setHZoomFactor(zoom -= 1.0f);
                } else {
                    PhysicalGraph.this.setHZoomFactor(zoom / 2.0f);
                }
            }
        };
        Action calcStartTimeOffset = new Action(Messages.getString("PhysicalGraph.calcStartTimeOffset"), Activator.getImageDescriptor("icons/calc_clock_offset.gif")){

            public void run() {
                PhysicalGraph.this.calcStartTimeOffset();
                PhysicalGraph.this.eventGraphPaintListener.updateMaxTimeStop();
                PhysicalGraph.this.redraw();
            }
        };
        Action messages = new Action(Messages.getString("PhysicalGraph.Toggle_Messages"), Activator.getImageDescriptor("icons/toggle_messages.gif")){

            public int getStyle() {
                return 2;
            }

            public boolean isChecked() {
                return PhysicalGraph.this.eventGraphPaintListener.isDrawMessages();
            }

            public void run() {
                PhysicalGraph.this.toggleMessageDrawing();
            }
        };
        Vector<Object> items = new Vector<Object>();
        IContributionItem[] iContributionItemArray = superItems;
        int n = superItems.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            items.add(item);
            ++n2;
        }
        items.add(new ActionContributionItem((IAction)calcStartTimeOffset));
        items.add(new ActionContributionItem((IAction)messages));
        items.add(new ActionContributionItem((IAction)vzoomin));
        items.add(new ActionContributionItem((IAction)vzoomout));
        items.add(new ActionContributionItem((IAction)hzoomin));
        items.add(new ActionContributionItem((IAction)hzoomout));
        items.add(new Separator());
        return items.toArray(new IContributionItem[items.size()]);
    }
}

