/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.preferences;

import eu.geclipse.traceview.internal.Activator;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class EventPreferenceEditor {
    IPreferenceStore store;
    String preference;
    String label;
    Button drawButton;
    Button button;
    Combo combo;

    public EventPreferenceEditor(Composite composite, String label, String preference) {
        this.label = label;
        this.preference = preference;
        this.store = Activator.getDefault().getPreferenceStore();
        Label name = new Label(composite, 0);
        name.setText(label);
        ColorSelector colorSelector = new ColorSelector(composite);
        colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.store, (String)(String.valueOf(preference) + "colorPreference")));
        GridData gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 16;
        colorSelector.getButton().setLayoutData((Object)gd);
        colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EventPreferenceEditor.this.handleColorPropertyChangeEvent(event);
            }
        });
        this.drawButton = new Button(composite, 32);
        this.drawButton.setSelection(this.store.getBoolean(String.valueOf(preference) + "drawPreference"));
        this.drawButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EventPreferenceEditor.this.handleDrawPropertyChangeEvent();
            }
        });
        colorSelector = new ColorSelector(composite);
        colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.store, (String)(String.valueOf(preference) + "fillColorPreference")));
        gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 16;
        colorSelector.getButton().setLayoutData((Object)gd);
        colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EventPreferenceEditor.this.handleFillColorPropertyChangeEvent(event);
            }
        });
        this.button = new Button(composite, 32);
        this.button.setSelection(this.store.getBoolean(String.valueOf(preference) + "fillPreference"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EventPreferenceEditor.this.handleFillPropertyChangeEvent();
            }
        });
        this.combo = new Combo(composite, 8);
        int selection = 0;
        switch (selection) {
            case 1: {
                selection = 0;
                break;
            }
            case 2: {
                selection = 1;
                break;
            }
            case 4: {
                selection = 2;
                break;
            }
            case 8: {
                selection = 3;
                break;
            }
            case 16: {
                selection = 4;
                break;
            }
            case 32: {
                selection = 5;
                break;
            }
            default: {
                selection = 0;
            }
        }
        this.combo.setItems(new String[]{"None", "Rectangle", "Circle", "Cross", "Triangle", "Diamond"});
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EventPreferenceEditor.this.handleSelectionEvent2();
            }
        });
        this.combo.select(selection);
    }

    protected void handleDrawPropertyChangeEvent() {
        this.store.setValue(String.valueOf(this.preference) + "drawPreference", this.drawButton.getSelection());
    }

    protected void handleFillPropertyChangeEvent() {
        this.store.setValue(String.valueOf(this.preference) + "fillPreference", this.button.getSelection());
    }

    protected void handleColorPropertyChangeEvent(PropertyChangeEvent event) {
        if (event.getNewValue() instanceof RGB) {
            RGB rgb = (RGB)event.getNewValue();
            PreferenceConverter.setValue((IPreferenceStore)this.store, (String)(String.valueOf(this.preference) + "colorPreference"), (RGB)rgb);
        }
    }

    protected void handleFillColorPropertyChangeEvent(PropertyChangeEvent event) {
        if (event.getNewValue() instanceof RGB) {
            RGB rgb = (RGB)event.getNewValue();
            PreferenceConverter.setValue((IPreferenceStore)this.store, (String)(String.valueOf(this.preference) + "fillColorPreference"), (RGB)rgb);
        }
    }

    protected void handleSelectionEvent2() {
        int value = 0;
        switch (this.combo.getSelectionIndex()) {
            case 0: {
                value = 1;
                break;
            }
            case 1: {
                value = 2;
                break;
            }
            case 2: {
                value = 4;
                break;
            }
            case 3: {
                value = 8;
                break;
            }
            case 4: {
                value = 16;
                break;
            }
            case 5: {
                value = 32;
                break;
            }
            default: {
                value = -1;
            }
        }
        this.store.setValue(String.valueOf(this.preference) + "fillColorPreference", value);
    }
}

