/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.utils;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ILamportEvent;
import eu.geclipse.traceview.ILamportProcess;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.IPhysicalProcess;
import eu.geclipse.traceview.internal.Activator;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractProcess
implements ILamportProcess,
IPhysicalProcess {
    protected int startTimeOffset;

    public String toString() {
        return "Process: " + this.getProcessId();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public Object getEditableValue() {
        return null;
    }

    public IEvent[] getEventsByLogicalClock(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        return null;
    }

    public int getMaximumLamportClock() {
        return ((ILamportEvent)this.getEventByLogicalClock(this.getMaximumLogicalClock())).getLamportClock();
    }

    public ILamportEvent getEventByLamportClock(int index) {
        ILamportEvent result = null;
        int low = 0;
        int high = this.getMaximumLogicalClock();
        while (low <= high) {
            int mid = (low + high) / 2;
            result = (ILamportEvent)this.getEventByLogicalClock(mid);
            if (result.getLamportClock() > index) {
                high = mid - 1;
                continue;
            }
            if (result.getLamportClock() >= index) break;
            low = mid + 1;
        }
        if (result.getLamportClock() != index) {
            result = null;
        }
        return result;
    }

    public ILamportEvent[] getEventsByLamportClock(int from, int to) {
        ILamportEvent[] events = null;
        try {
            int searchFrom = from;
            ILamportEvent fromEvent = null;
            while (fromEvent == null && searchFrom <= to) {
                fromEvent = this.getEventByLamportClock(searchFrom);
                ++searchFrom;
            }
            if (fromEvent == null) {
                return new ILamportEvent[0];
            }
            --searchFrom;
            int searchTo = to < this.getMaximumLamportClock() ? to : this.getMaximumLamportClock();
            IEvent toEvent = null;
            while (toEvent == null && searchTo >= searchFrom) {
                toEvent = this.getEventByLamportClock(searchTo);
                --searchTo;
            }
            if (toEvent == null) {
                return new ILamportEvent[0];
            }
            int length = toEvent.getLogicalClock() - fromEvent.getLogicalClock() + 1;
            events = new ILamportEvent[length];
            int i = 0;
            int logicalClock = fromEvent.getLogicalClock();
            while (i < length) {
                events[i] = (ILamportEvent)this.getEventByLogicalClock(logicalClock);
                ++logicalClock;
                ++i;
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        return events;
    }

    public int getMaximumPhysicalClock() {
        return ((IPhysicalEvent)this.getEventByLogicalClock(this.getMaximumLogicalClock())).getPhysicalStopClock();
    }

    protected IPhysicalEvent getPhysicalEvent(int time) {
        IPhysicalEvent result = null;
        int low = 0;
        int high = this.getMaximumLogicalClock();
        while (low <= high) {
            int mid = (low + high) / 2;
            IPhysicalEvent event = (IPhysicalEvent)this.getEventByLogicalClock(mid);
            if (event.getPhysicalStartClock() > time) {
                high = mid - 1;
                continue;
            }
            if (event.getPhysicalStopClock() < time) {
                low = mid + 1;
                continue;
            }
            result = event;
            break;
        }
        if (result == null && low <= this.getMaximumLogicalClock()) {
            result = (IPhysicalEvent)this.getEventByLogicalClock(low);
        }
        return result;
    }

    public IPhysicalEvent[] getEventsByPhysicalClock(int timeStart, int timeStop) {
        ArrayList<IPhysicalEvent> events = new ArrayList<IPhysicalEvent>();
        try {
            IPhysicalEvent event = this.getPhysicalEvent(timeStart);
            if (event != null) {
                if (event.getPhysicalStartClock() <= timeStop) {
                    events.add(event);
                }
                event = (IPhysicalEvent)this.getEventByLogicalClock(event.getLogicalClock() + 1);
                while (event != null && event.getPhysicalStartClock() < timeStop) {
                    events.add(event);
                    event = (IPhysicalEvent)event.getNextEvent();
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return events.toArray(new IPhysicalEvent[0]);
    }

    public int getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(int startTimeOffset) {
        this.startTimeOffset = startTimeOffset;
    }
}

