/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.utils;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.ILamportProcess;
import eu.geclipse.traceview.ILamportTrace;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.utils.IEventPartnerLogicalClockSetter;
import eu.geclipse.traceview.utils.ILamportEventClockSetter;

public class ClockCalculator {
    public static void calcLamportClock(ILamportTrace trace) {
        boolean allLamportClocksUpdated;
        boolean[] lamportClocksUpdated = new boolean[trace.getNumberOfProcesses()];
        int[] lastLogicalClock = new int[trace.getNumberOfProcesses()];
        int[] lastLamportClock = new int[trace.getNumberOfProcesses()];
        do {
            allLamportClocksUpdated = true;
            int procId = 0;
            while (procId < trace.getNumberOfProcesses()) {
                ILamportProcess process = (ILamportProcess)trace.getProcess(procId);
                if (!lamportClocksUpdated[procId]) {
                    while (lastLogicalClock[procId] <= process.getMaximumLogicalClock()) {
                        ILamportEventClockSetter event = (ILamportEventClockSetter)process.getEventByLogicalClock(lastLogicalClock[procId]);
                        if (event.getType() == EventType.RECV) {
                            ILamportEventClockSetter partnerEvent = (ILamportEventClockSetter)((ILamportProcess)trace.getProcess(event.getPartnerProcessId())).getEventByLogicalClock(event.getPartnerLogicalClock());
                            int partnerLamClock = partnerEvent.getLamportClock();
                            if (partnerLamClock == -1) break;
                            if (lastLamportClock[procId] < partnerLamClock + 1) {
                                lastLamportClock[procId] = partnerLamClock + 1;
                            }
                            event.setPartnerLamportClock(partnerLamClock);
                            partnerEvent.setPartnerLamportClock(lastLamportClock[procId]);
                        }
                        event.setLamportClock(lastLamportClock[procId]);
                        int n = procId;
                        lastLamportClock[n] = lastLamportClock[n] + 1;
                        int n2 = procId;
                        lastLogicalClock[n2] = lastLogicalClock[n2] + 1;
                    }
                    if (lastLogicalClock[procId] == process.getMaximumLogicalClock() + 1) {
                        lamportClocksUpdated[procId] = true;
                    }
                }
                allLamportClocksUpdated &= lamportClocksUpdated[procId];
                ++procId;
            }
        } while (!allLamportClocksUpdated);
    }

    public static void calcPartnerLogicalClocks(ITrace trace) {
        int[] currentIndex = new int[trace.getNumberOfProcesses()];
        int i = 0;
        while (i < trace.getNumberOfProcesses()) {
            int j = 0;
            while (j < trace.getNumberOfProcesses()) {
                currentIndex[j] = 0;
                ++j;
            }
            j = 0;
            while (j <= trace.getProcess(i).getMaximumLogicalClock()) {
                IEventPartnerLogicalClockSetter event = (IEventPartnerLogicalClockSetter)trace.getProcess(i).getEventByLogicalClock(j);
                if (event.getType() == EventType.RECV) {
                    IEventPartnerLogicalClockSetter partnerEvent;
                    int partnerId = event.getPartnerProcessId();
                    do {
                        partnerEvent = (IEventPartnerLogicalClockSetter)trace.getProcess(partnerId).getEventByLogicalClock(currentIndex[partnerId]);
                        int n = partnerId;
                        currentIndex[n] = currentIndex[n] + 1;
                    } while (partnerEvent.getType() != EventType.SEND || partnerEvent.getPartnerProcessId() != i);
                    event.setPartnerLogicalClock(currentIndex[partnerId] - 1);
                    partnerEvent.setPartnerLogicalClock(event.getLogicalClock());
                }
                ++j;
            }
            ++i;
        }
    }
}

