/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.views;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceVisProvider;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.views.TraceView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class DropDown
implements IMenuCreator {
    TraceView view;
    String id;

    DropDown(TraceView view, String id) {
        this.view = view;
        this.id = id;
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fill(menu);
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Menu m = new Menu(parent);
        MenuItem item = new MenuItem(m, 8);
        item.setText(Messages.getString("DropDown.switchVisualization"));
        return m;
    }

    void fill(Menu menu) {
        ITrace trace = this.view.getTrace();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.TraceVisualization");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                ITraceVisProvider provider = (ITraceVisProvider)configurationElement.createExecutableExtension("class");
                if (provider.supports(trace)) {
                    MenuItem item = new MenuItem(menu, 32);
                    item.setText(configurationElement.getAttribute("label"));
                    item.setImage(provider.getImage());
                    if (configurationElement.getAttribute("id").equals(this.id)) {
                        item.setSelection(true);
                    }
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            DropDown.this.view.traceVisPage.changeToVisualisation(configurationElement.getAttribute("id"));
                        }
                    });
                }
            }
            catch (CoreException exception) {
                Activator.logException((Exception)((Object)exception));
            }
            ++n2;
        }
    }
}

