/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.comparators;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableColumnComparator
extends ViewerComparator {
    private TableViewer tableViewer;
    private Table table;
    private ITableLabelProvider labelProvider;
    private TableColumn defaultSortColumn;

    public TableColumnComparator(TableColumn defaultSortColumn) {
        this.defaultSortColumn = defaultSortColumn;
    }

    public int category(Object element) {
        int type = 0;
        IResource res = null;
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            res = (IResource)adaptable.getAdapter(IResource.class);
        }
        if (res != null) {
            type = -res.getType();
        }
        return type;
    }

    public int compare(Viewer viewer, Object element1, Object element2) {
        int cat2;
        int cat1;
        int result;
        if (this.labelProvider == null) {
            this.initialize(viewer);
        }
        if ((result = (cat1 = this.category(element1)) - (cat2 = this.category(element2))) == 0) {
            int col = this.table.getSortColumn() == null ? 0 : this.table.indexOf(this.table.getSortColumn());
            int order = this.table.getSortDirection() == 1024 ? 1024 : 128;
            String value1 = this.labelProvider.getColumnText(element1, col);
            String value2 = this.labelProvider.getColumnText(element2, col);
            int n = result = order == 128 ? value1.compareToIgnoreCase(value2) : value2.compareToIgnoreCase(value1);
        }
        if (result == 0) {
            int sCol = this.table.indexOf(this.defaultSortColumn);
            String value1 = this.labelProvider.getColumnText(element1, sCol);
            String value2 = this.labelProvider.getColumnText(element2, sCol);
            result = value1.compareToIgnoreCase(value2);
        }
        return result;
    }

    private void initialize(Viewer viewer) {
        assert (viewer instanceof TableViewer);
        this.tableViewer = (TableViewer)viewer;
        this.table = this.tableViewer.getTable();
        IBaseLabelProvider lProvider = this.tableViewer.getLabelProvider();
        if (lProvider instanceof ITableLabelProvider) {
            this.labelProvider = (ITableLabelProvider)lProvider;
        }
    }
}

