/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.CertificateInfoPanel;
import java.net.URL;
import java.security.cert.X509Certificate;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class CertificateInfoDialog
extends TitleAreaDialog {
    private CertificateInfoPanel infoPanel;
    private X509Certificate[] certificateChain;

    public CertificateInfoDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
        URL imgURL = Activator.getDefault().getBundle().getResource("icons/wizban/cacert_wiz.gif");
        ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imgURL);
        this.setTitleImage(imgDesc.createImage());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Certificate Information");
    }

    public static void openDialog(Shell parentShell, X509Certificate certificate) {
        CertificateInfoDialog dialog = new CertificateInfoDialog(parentShell);
        dialog.setCertificate(certificate);
        dialog.open();
    }

    public void setCertificate(X509Certificate certificate) {
        this.setCertificateChain(new X509Certificate[]{certificate});
    }

    public void setCertificateChain(X509Certificate[] chain) {
        this.certificateChain = chain;
        if (this.infoPanel != null && !this.infoPanel.isDisposed() && chain != null && chain.length > 0) {
            this.internalSetCertificateChain(chain);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Label topRule = new Label(parent, 258);
        topRule.setLayoutData((Object)new GridData(768));
        this.infoPanel = new CertificateInfoPanel(parent, 0);
        this.infoPanel.setLayoutData(new GridData(4, 4, true, true));
        Label bottomRule = new Label(parent, 258);
        bottomRule.setLayoutData((Object)new GridData(768));
        if (this.certificateChain != null && this.certificateChain.length > 0) {
            this.internalSetCertificateChain(this.certificateChain);
        }
        this.setMessage("Information about X.509 based certificates.");
        return this.infoPanel;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    private void internalSetCertificateChain(X509Certificate[] chain) {
        this.infoPanel.setCertificateChain(chain);
        this.setTitle(chain[0].getSubjectX500Principal().getName());
    }
}

