/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.dialogs.configureFilters.FilterCompositeFactory;
import eu.geclipse.ui.internal.dialogs.configureFilters.IFilterComposite;
import eu.geclipse.ui.views.filters.GridFilterConfigurationsManager;
import eu.geclipse.ui.views.filters.IGridFilter;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureFiltersDialog
extends TrayDialog {
    protected TableViewer tableViewer;
    protected List<IFilterComposite> composites = new ArrayList<IFilterComposite>();
    protected List<IGridFilterConfiguration> configurations;
    protected GridFilterConfigurationsManager configurationsManager;

    public ConfigureFiltersDialog(Shell shell, GridFilterConfigurationsManager filterConfigurationsManager) {
        super(shell);
        this.configurationsManager = filterConfigurationsManager;
        this.configurations = this.copyConfigurations(filterConfigurationsManager.getConfigurations());
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.getString("ConfigureFiltersDialog.shell_text"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        ((GridLayout)dialogAreaComposite.getLayout()).numColumns = 2;
        this.createConfigurationsComposite(dialogAreaComposite);
        this.createFiltersComposite(dialogAreaComposite);
        this.selectEnabledConfiguration();
        return dialogAreaComposite;
    }

    private void createConfigurationsComposite(Composite parent) {
        Composite configComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        configComposite.setLayout((Layout)layout);
        configComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        this.createTableLabel(configComposite);
        this.createConfigsTable(configComposite);
        this.createTableButtons(configComposite);
    }

    private void createTableLabel(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("ConfigureFiltersDialog.table_label"));
    }

    private void createConfigsTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 2048);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.createTableLabelProvider());
        this.tableViewer.addSelectionChangedListener(this.createTableSelectionListener());
        GridData gridData = new GridData();
        gridData.heightHint = 150;
        gridData.widthHint = 75;
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tableViewer.setInput(this.configurations);
    }

    protected void enableConfiguration(IGridFilterConfiguration configuration) {
        for (IGridFilterConfiguration curConfiguration : this.configurations) {
            curConfiguration.setEnabled(curConfiguration == configuration);
        }
    }

    private ILabelProvider createTableLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((IGridFilterConfiguration)element).getName();
            }
        };
    }

    ISelectionChangedListener createTableSelectionListener() {
        return new ISelectionChangedListener(){
            private IGridFilterConfiguration selectedConfiguration;

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection != null) {
                    if (ConfigureFiltersDialog.this.saveFilter()) {
                        this.selectedConfiguration = (IGridFilterConfiguration)selection.getFirstElement();
                        ConfigureFiltersDialog.this.enableConfiguration(this.selectedConfiguration);
                        for (IFilterComposite filterComposite : ConfigureFiltersDialog.this.composites) {
                            filterComposite.setFilter(this.selectedConfiguration);
                        }
                    } else {
                        ConfigureFiltersDialog.this.tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                        ConfigureFiltersDialog.this.tableViewer.setSelection((ISelection)(this.selectedConfiguration != null ? new StructuredSelection((Object)this.selectedConfiguration) : null));
                        ConfigureFiltersDialog.this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    }
                }
                ConfigureFiltersDialog.this.setEnabledComposites(selection != null && !selection.isEmpty());
            }
        };
    }

    void setEnabledComposites(boolean enabled) {
        for (IFilterComposite filterComposite : this.composites) {
            filterComposite.setEnabled(enabled);
        }
    }

    private void createTableButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        buttonsComposite.setLayoutData((Object)gridData);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        this.createNewButton(buttonsComposite);
        this.createDeleteButton(buttonsComposite);
    }

    private void createNewButton(Composite parent) {
        Button button = this.createButton(parent, Messages.getString("ConfigureFiltersDialog.new_button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog;
                if (ConfigureFiltersDialog.this.saveFilter() && (dialog = new InputDialog(ConfigureFiltersDialog.this.getShell(), Messages.getString("ConfigureFiltersDialog.create_new_filter"), Messages.getString("ConfigureFiltersDialog.enter_filter_name"), "", this.createNameValidator())).open() == 0) {
                    IGridFilterConfiguration newConfiguration = ConfigureFiltersDialog.this.configurationsManager.createConfiguration(dialog.getValue());
                    ConfigureFiltersDialog.this.configurations.add(newConfiguration);
                    ConfigureFiltersDialog.this.tableViewer.add((Object)newConfiguration);
                    ConfigureFiltersDialog.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newConfiguration));
                }
            }

            private IInputValidator createNameValidator() {
                return new IInputValidator(){

                    public String isValid(String newText) {
                        String invalidMsg = null;
                        if (ConfigureFiltersDialog.this.findConfiguration(newText) != null) {
                            invalidMsg = String.format(Messages.getString("ConfigureFiltersDialog.filter_already_exists"), newText);
                        }
                        return invalidMsg;
                    }
                };
            }
        });
    }

    private void createDeleteButton(Composite parent) {
        Button button = this.createButton(parent, Messages.getString("ConfigureFiltersDialog.delete_button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigureFiltersDialog.this.saveFilter()) {
                    StructuredSelection selection = (StructuredSelection)ConfigureFiltersDialog.this.tableViewer.getSelection();
                    if (selection == null || selection.isEmpty()) {
                        MessageDialog.openWarning((Shell)ConfigureFiltersDialog.this.getShell(), (String)Messages.getString("ConfigureFiltersDialog.delete_filter"), (String)Messages.getString("ConfigureFiltersDialog.select_filter"));
                    } else {
                        IGridFilterConfiguration configuration = (IGridFilterConfiguration)selection.getFirstElement();
                        ConfigureFiltersDialog.this.tableViewer.remove((Object)configuration);
                        ConfigureFiltersDialog.this.configurations.remove(configuration);
                        ConfigureFiltersDialog.this.selectDefaultConfiguration();
                    }
                }
            }
        });
    }

    void selectDefaultConfiguration() {
        if (!this.configurations.isEmpty()) {
            IGridFilterConfiguration configuration = this.configurations.get(0);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)configuration));
        }
    }

    private Button createButton(Composite parent, String textString) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.setText(textString);
        return button;
    }

    private void createFiltersComposite(Composite parent) {
        Composite filtersComposite = new Composite(parent, 0);
        filtersComposite.setLayout((Layout)new GridLayout(2, false));
        IGridFilterConfiguration configuration = this.configurations.get(0);
        for (IGridFilter filter : configuration.getFilters()) {
            IFilterComposite composite = FilterCompositeFactory.create(filter, filtersComposite);
            Assert.isTrue((composite != null ? 1 : 0) != 0, (String)"Probably IGridFilter.makeClone() returned null");
            if (composite == null) continue;
            this.composites.add(composite);
        }
    }

    private List<IGridFilterConfiguration> copyConfigurations(List<IGridFilterConfiguration> sourceConfigurations) {
        ArrayList<IGridFilterConfiguration> newConfigurations = new ArrayList<IGridFilterConfiguration>(3 + (sourceConfigurations != null ? sourceConfigurations.size() : 0));
        if (sourceConfigurations != null) {
            try {
                for (IGridFilterConfiguration configuration : sourceConfigurations) {
                    newConfigurations.add(configuration.clone());
                }
            }
            catch (CloneNotSupportedException exception) {
                Activator.logException(exception);
            }
        }
        if (newConfigurations.isEmpty()) {
            IGridFilterConfiguration defaultConfiguration = this.configurationsManager.createConfiguration(Messages.getString("ConfigureFiltersDialog.default_config"));
            newConfigurations.add(defaultConfiguration);
        }
        return newConfigurations;
    }

    IGridFilterConfiguration findConfiguration(String name) {
        IGridFilterConfiguration foundConfiguration = null;
        Iterator<IGridFilterConfiguration> iterator = this.configurations.iterator();
        while (iterator.hasNext() && foundConfiguration == null) {
            IGridFilterConfiguration configuration = iterator.next();
            if (!configuration.getName().equals(name)) continue;
            foundConfiguration = configuration;
        }
        return foundConfiguration;
    }

    protected void okPressed() {
        if (this.saveFilter()) {
            super.okPressed();
        }
    }

    public List<IGridFilterConfiguration> getConfigurations() {
        return this.configurations;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean saveFilter() {
        boolean success = true;
        Iterator<IFilterComposite> iterator = this.composites.iterator();
        while (success && iterator.hasNext()) {
            IFilterComposite composite = iterator.next();
            success &= composite.saveToFilter();
        }
        return success;
    }

    private void selectEnabledConfiguration() {
        IGridFilterConfiguration enabledConfiguration;
        if (!this.configurations.isEmpty() && (enabledConfiguration = this.findEnabledConfiguration()) != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)enabledConfiguration));
        }
    }

    private IGridFilterConfiguration findEnabledConfiguration() {
        IGridFilterConfiguration enabledConfiguration = null;
        Iterator<IGridFilterConfiguration> iterator = this.configurations.iterator();
        while (iterator.hasNext() && enabledConfiguration == null) {
            IGridFilterConfiguration configuration = iterator.next();
            if (!configuration.isEnabled()) continue;
            enabledConfiguration = configuration;
        }
        return enabledConfiguration;
    }
}

