/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.LogExceptionSolution;
import eu.geclipse.ui.internal.ReportProblemSolution;
import eu.geclipse.ui.internal.layout.PackData;
import eu.geclipse.ui.internal.layout.PackLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProblemDialog
extends ErrorDialog {
    public static final int SOLVE = 2;
    private final Throwable exc;

    private ProblemDialog(Shell parentShell, String dialogTitle, String message, Throwable exc) {
        super(parentShell, dialogTitle, message, ProblemDialog.getStatus(exc), 7);
        this.message = message;
        this.exc = exc;
    }

    public static int openProblem(Shell parent, String dialogTitle, String message, Throwable exc) {
        IWorkbench workbench;
        IWorkbenchWindow window;
        Shell shell = parent;
        if (shell == null && (window = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        ProblemDialog dialog = new ProblemDialog(shell, dialogTitle, message, exc);
        if (shell != null) {
            Display display = Display.getCurrent();
            if (display == null || display.isDisposed()) {
                display = Display.getDefault();
            }
            display.syncExec(new Runnable(){

                public void run() {
                    ProblemDialog.this.open();
                }
            });
        }
        return dialog.getReturnCode();
    }

    protected Control createMessageArea(Composite parent) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(parent, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.imageLabel.setLayoutData((Object)new GridData(66));
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1794));
        composite.setLayout((Layout)new PackLayout(512));
        this.createLabelArea(composite);
        this.createReasonArea(composite);
        this.createSolutionArea(composite);
        return composite;
    }

    protected void createLabelArea(Composite parent) {
        if (this.message != null) {
            int wHint = this.convertHorizontalDLUsToPixels(300);
            final ScrolledComposite sComp = this.createListArea("Message:", parent, 100);
            final Composite comp = new Composite((Composite)sComp, 0);
            sComp.setContent((Control)comp);
            comp.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(comp, 64);
            label.setText(this.message);
            GridData gData = new GridData(768);
            gData.grabExcessHorizontalSpace = true;
            gData.widthHint = wHint;
            label.setLayoutData((Object)gData);
            Point size = comp.computeSize(wHint, -1);
            comp.setSize(size);
            sComp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = sComp.getClientArea();
                    Point cSize = comp.computeSize(r.width, -1);
                    comp.setSize(cSize);
                }
            });
        }
    }

    protected void createReasonArea(Composite parent) {
        String[] reasons = this.getReasons();
        if (reasons != null && reasons.length > 0) {
            ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
            Image reasonImage = imgReg.get("reason");
            final ScrolledComposite sComp = this.createListArea("Reasons:", parent, 200);
            final Composite reasonList = new Composite((Composite)sComp, 0);
            sComp.setContent((Control)reasonList);
            reasonList.setLayout((Layout)new GridLayout(2, false));
            String[] stringArray = reasons;
            int n = reasons.length;
            int n2 = 0;
            while (n2 < n) {
                String reason = stringArray[n2];
                Label imgLabel = new Label(reasonList, 0);
                imgLabel.setImage(reasonImage);
                GridData gData = new GridData();
                gData.horizontalAlignment = 2;
                gData.verticalAlignment = 1;
                imgLabel.setLayoutData((Object)gData);
                Label label = new Label(reasonList, 64);
                label.setText(reason);
                gData = new GridData(768);
                gData.grabExcessHorizontalSpace = true;
                gData.horizontalAlignment = 1;
                label.setLayoutData((Object)gData);
                ++n2;
            }
            int wHint = this.convertHorizontalDLUsToPixels(300);
            reasonList.setSize(reasonList.computeSize(wHint, -1));
            sComp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = sComp.getClientArea();
                    Point cSize = reasonList.computeSize(r.width, -1);
                    reasonList.setSize(cSize);
                }
            });
        }
    }

    protected void createSolutionArea(Composite parent) {
        ISolution[] solutions = this.getSolutions();
        if (solutions != null && solutions.length > 0) {
            ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
            Image solutionImage = imgReg.get("solution");
            final ScrolledComposite sComp = this.createListArea(Messages.getString("ProblemDialog.solutions_label"), parent, 200);
            final Composite solutionList = new Composite((Composite)sComp, 0);
            sComp.setContent((Control)solutionList);
            solutionList.setLayout((Layout)new GridLayout(2, false));
            ISolution[] iSolutionArray = solutions;
            int n = solutions.length;
            int n2 = 0;
            while (n2 < n) {
                final ISolution solution = iSolutionArray[n2];
                Label imgLabel = new Label(solutionList, 0);
                imgLabel.setImage(solutionImage);
                GridData gData = new GridData();
                gData.horizontalAlignment = 2;
                gData.verticalAlignment = 1;
                imgLabel.setLayoutData((Object)gData);
                Link link = new Link(solutionList, 64);
                String text = solution.getDescription();
                if (solution.isActive()) {
                    link.setText("<a>" + text + "</a>");
                } else {
                    link.setText(text);
                }
                gData = new GridData(768);
                gData.grabExcessHorizontalSpace = true;
                gData.horizontalAlignment = 1;
                link.setLayoutData((Object)gData);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProblemDialog.this.setReturnCode(2);
                        ProblemDialog.this.close();
                        try {
                            solution.solve();
                        }
                        catch (InvocationTargetException itExc) {
                            Throwable cause = itExc.getCause();
                            Activator.logException(cause);
                        }
                    }
                });
                ++n2;
            }
            int wHint = this.convertHorizontalDLUsToPixels(300);
            solutionList.setSize(solutionList.computeSize(wHint, -1));
            sComp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = sComp.getClientArea();
                    Point cSize = solutionList.computeSize(r.width, -1);
                    solutionList.setSize(cSize);
                }
            });
        }
    }

    protected IProblem getProblem() {
        IProblem result = null;
        if (this.exc != null && this.exc instanceof ProblemException) {
            result = ((ProblemException)this.exc).getProblem();
        }
        return result;
    }

    protected String[] getReasons() {
        String[] reasons;
        IProblem problem;
        ArrayList<String> resultList = new ArrayList<String>();
        IStatus status = this.getStatus();
        if (status != null) {
            resultList.add(status.getMessage());
        }
        if ((problem = this.getProblem()) != null && (reasons = problem.getReasons()) != null) {
            String[] stringArray = reasons;
            int n = reasons.length;
            int n2 = 0;
            while (n2 < n) {
                String reason = stringArray[n2];
                resultList.add(reason);
                ++n2;
            }
        }
        return resultList.isEmpty() ? null : resultList.toArray(new String[resultList.size()]);
    }

    protected ISolution[] getSolutions() {
        ArrayList<ISolution> resultList = new ArrayList<ISolution>();
        IProblem problem = this.getProblem();
        if (problem != null) {
            List<ISolution> list = Arrays.asList(problem.getSolutions());
            resultList.addAll(list);
        }
        if (this.exc != null) {
            resultList.add(new LogExceptionSolution(this.exc));
            resultList.add(new ReportProblemSolution(this.exc));
        }
        return resultList.toArray(new ISolution[resultList.size()]);
    }

    protected IStatus getStatus() {
        return ProblemDialog.getStatus(this.exc);
    }

    private ScrolledComposite createListArea(String title, Composite parent, int maxScrollableHeight) {
        Composite comp = new Composite(parent, 0);
        PackLayout layout = new PackLayout(512);
        comp.setLayout((Layout)layout);
        PackData pData = new PackData();
        comp.setLayoutData((Object)pData);
        Label label = new Label(comp, 0);
        label.setText(title);
        ScrolledComposite sComp = new ScrolledComposite(comp, 512);
        pData = new PackData();
        pData.minHeight = 10;
        pData.maxHeight = maxScrollableHeight;
        sComp.setLayoutData((Object)pData);
        return sComp;
    }

    private static IStatus getStatus(Throwable throwable) {
        IStatus result = null;
        if (throwable != null && throwable instanceof CoreException) {
            result = ((CoreException)throwable).getStatus();
        } else {
            String message = null;
            if (throwable != null) {
                message = throwable.getMessage();
            }
            if (message == null) {
                message = Messages.getString("ProblemDialog.no_further_info");
            }
            result = new Status(4, "eu.geclipse.ui", 0, message, throwable);
        }
        return result;
    }
}

