/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.ui.internal.transfer.TransferResumer;
import eu.geclipse.ui.properties.PropertiesAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.geclipse.ui";
    public static final String ID_GPROJECT_VIEW = "eu.geclipse.ui.views.gridProjectView";
    public static final String ID_AUTH_VIEW = "eu.geclipse.ui.views.authenticationTokenView";
    public static final String ID_CONNECTION_VIEW = "eu.geclipse.ui.views.connectionView";
    public static final String ID_JOB_VIEW = "eu.geclipse.ui.views.jobView";
    public static final String ID_GLUE_INFO_VIEW = "eu.geclipse.info.ui.GlueInfoViewer";
    public static final String ID_GVID_VIEW = "eu.geclipse.gvid.views.GVidView";
    public static final String ID_TERMINAL_VIEW = "eu.geclipse.terminal.views.TerminalView";
    public static final String ID_WEB_VIEW = "eu.geclipse.webview.views.WebView";
    public static final String ID_JOBS_VIEW = "eu.geclipse.ui.views.jobView";
    public static final String ID_JOBDETAILS_VIEW = "eu.geclipse.ui.views.jobdetails.JobDetailsView";
    public static final String ID_PROJECT_WIZARD = "eu.geclipse.ui.wizards.gridProjectWizard";
    public static final String ID_CONNECTION_WIZARD = "eu.geclipse.ui.wizards.connectionWizard";
    public static final String ID_WORKFLOW_WIZARD = "eu.geclipse.workflow.ui.part.WorkflowCreationWizardID";
    public static final String ID_USER_PERSPECTIVE = "eu.geclipse.ui.userPerspective";
    public static final String ID_OPERATOR_PERSPECTIVE = "eu.geclipse.ui.operatorPerspective";
    public static final String ID_DEVELOPER_PERSPECTIVE = "eu.geclipse.ui.developerPerspective";
    public static final String ID_EXPLORER_PERSPECTIVE = "eu.geclipse.ui.explorerPerspective";
    public static final String IMG_REFRESH = "refresh";
    public static final String IMG_DOWNLOAD_JOB_OUTPUT = "DownloadJobOutput";
    public static final String IMG_UPDATE_JOB_STATUS = "UpdateJobStatus";
    public static final String IMG_SEE = "See";
    private static Activator plugin;
    private FormColors formColors;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PropertiesAdapterFactory.register();
        this.setPreferencesDefaults();
        TransferResumer resumer = new TransferResumer("Transfer resume");
        resumer.schedule(25000L);
    }

    private void setPreferencesDefaults() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        preferenceStore.setDefault("NotSwitchFromGEclipsePerspectives", true);
        preferenceStore.setDefault("DefaultPerspective", ID_USER_PERSPECTIVE);
        preferenceStore.setDefault("RememberSwitchingPerspective", "prompt");
    }

    public void stop(BundleContext context) throws Exception {
        PropertiesAdapterFactory.unregister();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Throwable exc) {
        String message = exc.getLocalizedMessage();
        if (message == null) {
            message = exc.getClass().getName();
        }
        Status status = new Status(4, PLUGIN_ID, 0, message, exc);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static void logStatus(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        String[][] images = new String[][]{{"activestate", "icons/elcl16/activate.gif"}, {"computing", "icons/obj16/computing_obj.gif"}, {"filesystem", "icons/obj16/filesystem_obj.gif"}, {"geclipse_logo_prefs", "icons/extras/geclipse_logo_prefs.gif"}, {"inactivestate", "icons/elcl16/deactivate.gif"}, {"invalidelement", "icons/obj16/invalid_element_obj.gif"}, {"job", "icons/obj16/job_file_obj.gif"}, {"jobdescription", "icons/obj16/jsdl_file_obj.gif"}, {"reason", "icons/obj16/ihigh_obj.gif"}, {IMG_REFRESH, "icons/elcl16/refresh_nav.gif"}, {"service", "icons/obj16/service_obj.gif"}, {"service_unsupported", "icons/obj16/service_unsupported_obj.gif"}, {"storage", "icons/obj16/storage_obj.gif"}, {"solution", "icons/obj16/quickassist_obj.gif"}, {"virtualfile", "icons/obj16/virtual_file_obj.gif"}, {"virtualfolder", "icons/obj16/virtual_folder_obj.gif"}, {"vo", "icons/obj16/vo_obj.gif"}, {"formsbackground", "icons/form_banner.gif"}, {"configure_filters", "icons/obj16/filter_ps.gif"}, {"configure_filters_on", "icons/obj16/filter_on.gif"}, {"helplink", "icons/elcl16/linkto_help.gif"}, {"calendar", "icons/calendar.gif"}, {IMG_REFRESH, "icons/eview16/refresh.gif"}, {IMG_DOWNLOAD_JOB_OUTPUT, "icons/DownloadJobOutput.gif"}, {IMG_UPDATE_JOB_STATUS, "icons/UpdateJobStatus.gif"}, {IMG_SEE, "icons/obj16/see.gif"}, {"emptyfoldermarker", "icons/obj16/ihigh_obj.gif"}, {"toggleTabBtn", "icons/main_tab.gif"}};
        ImageDescriptor imgDsc = null;
        String[][] stringArrayArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            String[] image = stringArrayArray[n2];
            imgDsc = Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)image[1]);
            reg.put(image[0], imgDsc);
            ++n2;
        }
    }
}

