/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.workflow.IGridWorkflowDescription;
import eu.geclipse.workflow.IGridWorkflowJobDescription;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteGridElementAction
extends SelectionListenerAction {
    Shell shell;
    private DeleteResourceAction eclipseAction;

    protected DeleteGridElementAction(final Shell shell) {
        super(Messages.getString("DeleteGridElementAction.actionNameDelete"));
        this.shell = shell;
        this.eclipseAction = new DeleteResourceAction(new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        });
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor deleteImage = sharedImages.getImageDescriptor("IMG_TOOL_DELETE");
        this.setImageDescriptor(deleteImage);
    }

    public void run() {
        ArrayList<IGridJob> selectedJobs = new ArrayList<IGridJob>(this.getSelectedResources().size());
        ArrayList<IGridJobDescription> selectedWorkflowJobDescriptions = new ArrayList<IGridJobDescription>(this.getSelectedResources().size());
        ArrayList<IResource> selectedResources = new ArrayList<IResource>(this.getSelectedResources().size());
        this.dispatchSelectedElements(selectedJobs, selectedWorkflowJobDescriptions, selectedResources);
        this.deactivateConnections(selectedResources.toArray(new IResource[selectedResources.size()]));
        if (!selectedJobs.isEmpty()) {
            this.deleteJobs(selectedJobs);
        }
        if (!selectedResources.isEmpty()) {
            this.deleteOtherResources(selectedResources);
        }
        if (!selectedWorkflowJobDescriptions.isEmpty()) {
            this.deleteWorkflowJobDescriptions(selectedWorkflowJobDescriptions);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return !this.getSelectedResources().isEmpty();
    }

    private void deactivateConnections(IResource[] resources) {
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IGridElement element = GridModel.getRoot().findElement(resource);
                if (element instanceof IGridConnectionElement) {
                    try {
                        IGridConnectionElement connection = (IGridConnectionElement)element;
                        IFileStore fileStore = connection.getConnectionFileStore();
                        GEclipseFileSystem.setFileStoreActive((IFileStore)fileStore, (boolean)false, (boolean)false, (boolean)false);
                        resource.refreshLocal(2, null);
                    }
                    catch (CoreException cExc) {
                        Activator.logException(cExc);
                    }
                }
                if (resource instanceof IContainer) {
                    try {
                        IResource[] members = ((IContainer)resource).members();
                        this.deactivateConnections(members);
                    }
                    catch (CoreException cExc) {
                        Activator.logException(cExc);
                    }
                }
                ++n2;
            }
        }
    }

    private void dispatchSelectedElements(List<IGridJob> selectedJobs, List<IGridJobDescription> selectedWorkflowJobDescriptions, List<IResource> otherSelectedResources) {
        for (Object obj : this.getSelectedResources()) {
            if (!(obj instanceof IResource)) continue;
            IResource resource = (IResource)obj;
            IGridElement element = GridModel.getRoot().findElement(resource);
            if (element instanceof IGridJob) {
                selectedJobs.add((IGridJob)element);
                continue;
            }
            if (element instanceof IGridJobDescription) {
                IGridContainer parent = element.getParent();
                if (parent instanceof IGridWorkflowDescription) {
                    boolean inWorkflow = false;
                    List childrenJobs = ((IGridWorkflowDescription)parent).getChildrenJobs();
                    for (IGridWorkflowJobDescription child : childrenJobs) {
                        String fullPath;
                        String childUri = child.getDescriptionPath().toString();
                        if (!childUri.equals(fullPath = element.getResource().getLocation().toString())) continue;
                        inWorkflow = true;
                    }
                    if (inWorkflow) {
                        selectedWorkflowJobDescriptions.add((IGridJobDescription)element);
                        continue;
                    }
                    otherSelectedResources.add(resource);
                    continue;
                }
                otherSelectedResources.add(resource);
                continue;
            }
            otherSelectedResources.add(resource);
        }
    }

    private void deleteOtherResources(List<IResource> selectedResources) {
        this.eclipseAction.selectionChanged((IStructuredSelection)new StructuredSelection(selectedResources));
        this.eclipseAction.run();
    }

    private void deleteWorkflowJobDescriptions(List<IGridJobDescription> selectedJobDescriptions) {
        MessageDialog dialog = null;
        String dialogMessage = "";
        if (selectedJobDescriptions.size() == 1) {
            IGridJobDescription selectedJobDesc = selectedJobDescriptions.get(0);
            String jsdl = selectedJobDesc.getResource().getName();
            dialogMessage = String.format(Messages.getString("DeleteGridElementAction.confirmJobDescDeleteOne"), jsdl);
        } else {
            String jsdlList = "";
            Iterator<IGridJobDescription> i = selectedJobDescriptions.iterator();
            while (i.hasNext()) {
                jsdlList = String.valueOf(jsdlList) + " " + i.next().getResource().getName();
            }
            dialogMessage = String.format(Messages.getString("DeleteGridElementAction.confirmJobDescDeleteMany"), jsdlList);
        }
        dialog = new MessageDialog(this.shell, Messages.getString("DeleteGridElementAction.confirmationTitle"), null, dialogMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dialog.open() == 0) {
            try {
                Iterator<IGridJobDescription> i1 = selectedJobDescriptions.iterator();
                while (i1.hasNext()) {
                    IResource r = i1.next().getResource();
                    r.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteJobs(List<IGridJob> selectedJobs) {
        ConfirmChoice choice = this.confirmDeleteJobs(selectedJobs);
        if (choice != ConfirmChoice.cancel) {
            DeleteJobsJob job = new DeleteJobsJob(selectedJobs, choice);
            job.setUser(true);
            job.schedule();
        }
    }

    private ConfirmChoice confirmDeleteJobs(List<IGridJob> selectedJobs) {
        ConfirmDeleteJobsDialog dialog;
        String warning;
        String question;
        ConfirmChoice choice;
        block4: {
            block3: {
                choice = ConfirmChoice.cancel;
                question = null;
                warning = null;
                if (selectedJobs.size() != 1) break block3;
                IGridJob job = selectedJobs.iterator().next();
                question = String.format(Messages.getString("DeleteGridElementAction.confirmationOne"), job.getJobName());
                if (!job.getJobStatus().canChange()) break block4;
                warning = String.format(Messages.getString("DeleteGridElementAction.warningOne"), job.getJobName());
                break block4;
            }
            question = String.format(Messages.getString("DeleteGridElementAction.confirmationMany"), selectedJobs.size());
            for (IGridJob job : selectedJobs) {
                if (!job.getJobStatus().canChange()) continue;
                warning = Messages.getString("DeleteGridElementAction.warningMany");
                break;
            }
        }
        String msg = question;
        if (warning != null) {
            msg = String.valueOf(msg) + "\n\n" + warning;
        }
        if ((dialog = new ConfirmDeleteJobsDialog(msg, warning == null ? 3 : 4)).open() == 0) {
            choice = dialog.isDeleteFromGrid() ? ConfirmChoice.deleteFromGrid : ConfirmChoice.deleteOnlyFromWorkspace;
        }
        return choice;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfirmChoice {
        deleteFromGrid,
        deleteOnlyFromWorkspace,
        cancel;

    }

    private class ConfirmDeleteJobsDialog
    extends MessageDialog {
        private Button deleteFromGridCheckbox;
        private boolean deleteFromGrid;

        ConfirmDeleteJobsDialog(String dialogMessage, int dialogImageType) {
            super(DeleteGridElementAction.this.shell, Messages.getString("DeleteGridElementAction.confirmationTitle"), null, dialogMessage, dialogImageType, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            this.deleteFromGridCheckbox = new Button(parent, 32);
            this.deleteFromGridCheckbox.setText(Messages.getString("DeleteGridElementAction.alsoDeleteFromGrid"));
            this.deleteFromGridCheckbox.setSelection(true);
            return super.createCustomArea(parent);
        }

        public boolean close() {
            this.deleteFromGrid = this.deleteFromGridCheckbox.getSelection();
            return super.close();
        }

        boolean isDeleteFromGrid() {
            return this.deleteFromGrid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteJobsJob
    extends Job {
        boolean forceDeleteLocal;
        private List<IGridJob> selectedJobs;
        private ConfirmChoice userChoice;

        public DeleteJobsJob(List<IGridJob> selectedJobs, ConfirmChoice userChoice) {
            super(Messages.getString("DeleteGridElementAction.deleteJobName"));
            this.forceDeleteLocal = false;
            this.selectedJobs = selectedJobs;
            this.userChoice = userChoice;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor);
            submonitor.setWorkRemaining(this.selectedJobs.size());
            try {
                Iterator<IGridJob> iterator = this.selectedJobs.iterator();
                IGridJob job = null;
                while (iterator.hasNext()) {
                    try {
                        this.testCancel((IProgressMonitor)submonitor);
                        job = iterator.next();
                        this.deleteJob(submonitor.newChild(1), job);
                        iterator.remove();
                    }
                    catch (ProblemException exception) {
                        this.addSolutionOnlyLocalDel(exception);
                        ProblemDialog.openProblem(DeleteGridElementAction.this.shell, Messages.getString("DeleteGridElementAction.deleteProblemTitle"), String.format(Messages.getString("DeleteGridElementAction.problemDescription"), job != null ? job.getJobName() : "unknown"), exception);
                        break;
                    }
                }
            }
            finally {
                submonitor.done();
            }
            return status;
        }

        private void deleteJob(SubMonitor monitor, IGridJob job) throws ProblemException {
            monitor.setTaskName(String.format(Messages.getString("DeleteGridElementAction.taskNameDeleting"), job.getJobName()));
            monitor.setWorkRemaining(this.userChoice == ConfirmChoice.deleteFromGrid ? 3 : 2);
            this.stopJobStatusUpdater(job, monitor.newChild(1));
            if (this.userChoice == ConfirmChoice.deleteFromGrid) {
                try {
                    job.deleteJob((IProgressMonitor)monitor.newChild(1));
                }
                catch (ProblemException exception) {
                    if (this.forceDeleteLocal) {
                        Activator.logException(exception);
                    }
                    throw exception;
                }
            }
            try {
                this.testCancel((IProgressMonitor)monitor);
                job.getResource().delete(true, (IProgressMonitor)monitor.newChild(1));
            }
            catch (CoreException exception) {
                throw new ProblemException("eu.geclipse.problem.deleteGridElementAction.cannotDeleteResource", (Throwable)exception, "eu.geclipse.ui");
            }
        }

        private void stopJobStatusUpdater(IGridJob job, SubMonitor monitor) {
            monitor.subTask(Messages.getString("DeleteGridElementAction.taskStoppingUpdater"));
            GridModel.getJobManager().removeJobStatusUpdater(job, true, (IProgressMonitor)monitor);
        }

        private void testCancel(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        void addSolutionOnlyLocalDel(ProblemException exception) {
            if (this.userChoice == ConfirmChoice.deleteFromGrid && !this.forceDeleteLocal) {
                IProblem problem = exception.getProblem();
                problem.addSolution(new ISolution(){

                    public String getDescription() {
                        return Messages.getString("DeleteGridElementAction.forceDeleteLocal");
                    }

                    public String getID() {
                        return null;
                    }

                    public boolean isActive() {
                        return true;
                    }

                    public void solve() throws InvocationTargetException {
                        DeleteJobsJob.this.forceDeleteLocal = true;
                        DeleteJobsJob.this.schedule();
                    }
                });
            }
        }
    }
}

