/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.Extensions;
import eu.geclipse.core.model.IMountable;
import eu.geclipse.ui.actions.MountAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CompoundContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MountMenu
extends CompoundContributionItem
implements ISelectionChangedListener {
    private Shell shell;
    private boolean mountAs;
    private List<IMountable> mountables = new ArrayList<IMountable>();
    private List<IMountable.MountPointID> mergedIDs = new ArrayList<IMountable.MountPointID>();

    public MountMenu(Shell shell, boolean mountAs) {
        super("eu.geclipse.ui.actions.newmount");
        this.shell = shell;
        this.mountAs = mountAs;
        this.checkVisible((IStructuredSelection)StructuredSelection.EMPTY, this.mergedIDs);
    }

    public void setParent(IContributionManager parent) {
        if (parent != null) {
            super.setParent(parent);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.mountables.clear();
        this.mergedIDs.clear();
        ISelection selection = event.getSelection();
        StructuredSelection sSelection = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            sSelection = (IStructuredSelection)selection;
            for (Object obj : sSelection) {
                if (!(obj instanceof IMountable)) continue;
                IMountable mount = (IMountable)obj;
                this.mountables.add(mount);
            }
        }
        this.mergedIDs = this.getMergedIDs(this.mountables);
        this.checkVisible((IStructuredSelection)sSelection, this.mergedIDs);
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] result = new IContributionItem[]{};
        if (!this.mergedIDs.isEmpty()) {
            result = new IContributionItem[this.mergedIDs.size()];
            int i = 0;
            while (i < this.mergedIDs.size()) {
                IAction action = this.getAction(this.mergedIDs.get(i));
                result[i] = new ActionContributionItem(action);
                ++i;
            }
        }
        return result;
    }

    private List<IMountable.MountPointID> getMergedIDs(List<IMountable> mounts) {
        List<IMountable.MountPointID> result = new ArrayList<IMountable.MountPointID>();
        int i = 0;
        while (i < mounts.size()) {
            IMountable.MountPointID[] mountIDs = mounts.get(i).getMountPointIDs();
            if (mountIDs != null) {
                result = this.mergeIDs(result, mountIDs, i == 0);
            }
            ++i;
        }
        return result;
    }

    private List<IMountable.MountPointID> mergeIDs(List<IMountable.MountPointID> ids, IMountable.MountPointID[] mountIDs, boolean first) {
        List<IMountable.MountPointID> result = ids;
        if (first) {
            IMountable.MountPointID[] mountPointIDArray = mountIDs;
            int n = mountIDs.length;
            int n2 = 0;
            while (n2 < n) {
                IMountable.MountPointID mountID = mountPointIDArray[n2];
                if (this.isSupported(mountID)) {
                    result.add(mountID);
                }
                ++n2;
            }
        } else {
            result = new ArrayList<IMountable.MountPointID>();
            block1: for (IMountable.MountPointID id : ids) {
                IMountable.MountPointID[] mountPointIDArray = mountIDs;
                int n = mountIDs.length;
                int n3 = 0;
                while (n3 < n) {
                    IMountable.MountPointID mountID = mountPointIDArray[n3];
                    if (id.equals((Object)mountID)) {
                        result.add(id);
                        continue block1;
                    }
                    ++n3;
                }
            }
        }
        return result;
    }

    protected IAction getAction(IMountable.MountPointID mountID) {
        IMountable[] srcArray = this.mountables.toArray(new IMountable[this.mountables.size()]);
        MountAction action = new MountAction(this.shell, srcArray, mountID, this.mountAs);
        return action;
    }

    private void checkVisible(IStructuredSelection selection, List<IMountable.MountPointID> ids) {
        int selCount = selection.size();
        int idCount = ids.size();
        this.setVisible(idCount > 0 && (this.mountAs && selCount == 1 || !this.mountAs && selCount > 0));
    }

    private boolean isSupported(IMountable.MountPointID mountID) {
        List schemes = Extensions.getRegisteredFilesystemSchemes();
        return schemes.contains(mountID.getScheme());
    }
}

