/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.TransferAction;
import eu.geclipse.ui.internal.transfer.GridElementTransferOperation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PasteAction
extends TransferAction {
    public PasteAction(Clipboard clipboard) {
        super(Messages.getString("PasteAction.paste_action_text"), clipboard);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor pasteImage = sharedImages.getImageDescriptor("IMG_TOOL_PASTE");
        this.setImageDescriptor(pasteImage);
    }

    public void run() {
        Clipboard clipboard = this.getClipboard();
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IStructuredSelection source = (IStructuredSelection)clipboard.getContents((Transfer)transfer);
        IStructuredSelection target = this.getStructuredSelection();
        this.startTransfer(source, target);
    }

    protected void startTransfer(IStructuredSelection source, IStructuredSelection target) {
        if (!this.isEmpty((ISelection)source) && !this.isEmpty((ISelection)target)) {
            Object[] sourceArray = source.toArray();
            IGridElement[] sourceElements = new IGridElement[source.size()];
            int i = 0;
            while (i < sourceArray.length) {
                if (sourceArray[i] instanceof IGridElement) {
                    sourceElements[i] = (IGridElement)sourceArray[i];
                }
                ++i;
            }
            Object targetObject = target.getFirstElement();
            IGridContainer targetContainer = null;
            if (targetObject instanceof IGridContainer) {
                targetContainer = (IGridContainer)targetObject;
            }
            if (targetContainer != null) {
                this.startTransfer(sourceElements, targetContainer);
            }
        }
    }

    protected void startTransfer(IGridElement[] sources, IGridContainer target) {
        GridElementTransferOperation op = new GridElementTransferOperation(sources, target, false);
        op.setUser(true);
        op.schedule();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = super.updateSelection(selection);
        if (result && selection.size() == 1 && selection.getFirstElement() instanceof IGridContainer) {
            Clipboard clipboard = this.getClipboard();
            TransferData[] data = clipboard.getAvailableTypes();
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
            result = false;
            TransferData[] transferDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                TransferData d = transferDataArray[n2];
                if (transfer.isSupportedType(d)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean isEmpty(ISelection selection) {
        return selection == null || selection.isEmpty();
    }
}

