/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;

public class ProjectActions
extends ActionGroup {
    private IWorkbenchSite site;
    private OpenResourceAction openAction;
    private CloseResourceAction closeAction;

    public ProjectActions(IWorkbenchSite site) {
        this.site = site;
        Shell shell = site.getShell();
        ISelectionProvider provider = site.getSelectionProvider();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.openAction = new OpenResourceAction(shell);
        this.closeAction = new CloseResourceAction(shell);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.openAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.closeAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.openAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeAction);
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.openAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.closeAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.openAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.openAction);
        }
        if (this.closeAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.closeAction);
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        this.openAction.selectionChanged(selection);
        this.closeAction.selectionChanged(selection);
    }
}

