/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs.configureFilters;

import eu.geclipse.ui.internal.dialogs.configureFilters.IFilterComposite;
import eu.geclipse.ui.internal.dialogs.configureFilters.Messages;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import eu.geclipse.ui.views.filters.JobStatusFilter;
import eu.geclipse.ui.views.filters.JobViewFilterConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JobStatusComposite
implements IFilterComposite {
    private JobStatusFilter filter;
    private List<StatusOption> optionsList = new ArrayList<StatusOption>();
    private Group topGroup;
    private boolean enabled = true;

    public JobStatusComposite(JobStatusFilter filter, Composite parent) {
        this.filter = filter;
        this.topGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.topGroup.setLayout((Layout)layout);
        this.topGroup.setLayoutData((Object)new GridData(4, 128, false, false));
        Label label = new Label((Composite)this.topGroup, 0);
        label.setText(Messages.getString("JobStatusComposite.Description"));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.submitted"), 1));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.waiting"), 2));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.running"), 4));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.done"), 8));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.aborted"), 16));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.purged"), 32));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.others"), 128));
        this.refresh();
    }

    public boolean saveToFilter() {
        if (this.filter != null) {
            for (StatusOption option : this.optionsList) {
                this.filter.setStatusState(option.getStatusValue(), option.isSelected());
            }
        }
        return true;
    }

    public void setFilter(IGridFilterConfiguration filterConfiguration) {
        this.filter = filterConfiguration == null ? null : ((JobViewFilterConfiguration)filterConfiguration).getJobStatusFilter();
        this.refresh();
    }

    private void refresh() {
        if (this.filter != null) {
            for (StatusOption option : this.optionsList) {
                option.setSelected(this.filter.getStatusState(option.getStatusValue()));
            }
            this.onChangeEnabledState();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.onChangeEnabledState();
    }

    void onChangeEnabledState() {
        for (StatusOption option : this.optionsList) {
            option.setEnabled(this.enabled);
        }
    }

    private static class StatusOption {
        private int statusValue;
        private Button checkbox;

        StatusOption(Composite parent, String descriptionString, int statusValue) {
            this.statusValue = statusValue;
            this.checkbox = new Button(parent, 32);
            this.checkbox.setText(descriptionString);
        }

        void setSelected(boolean selected) {
            this.checkbox.setSelection(selected);
        }

        boolean isSelected() {
            return this.checkbox.getSelection();
        }

        void enable(boolean enable) {
            this.checkbox.setEnabled(enable);
        }

        int getStatusValue() {
            return this.statusValue;
        }

        void setEnabled(boolean enabled) {
            this.checkbox.setEnabled(enabled);
        }
    }
}

