/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs.configureFilters;

import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.dialogs.configureFilters.IFilterComposite;
import eu.geclipse.ui.internal.dialogs.configureFilters.Messages;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import eu.geclipse.ui.views.filters.JobSubmissionTimeFilter;
import eu.geclipse.ui.views.filters.JobViewFilterConfiguration;
import eu.geclipse.ui.widgets.DateTimeText;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JobSubmissionTimeComposite
implements IFilterComposite {
    private JobSubmissionTimeFilter filter;
    private DateTimeText afterDateTimeText;
    private DateTimeText beforeDateTimeText;
    private Composite parent;

    public JobSubmissionTimeComposite(JobSubmissionTimeFilter filter, Composite parent) {
        this.filter = filter;
        this.parent = parent;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("JobSubmissionTimeComposite.afterDateDescription"));
        this.afterDateTimeText = new DateTimeText((Composite)group, DateTimeText.Style.DATETIME, true);
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("JobSubmissionTimeComposite.beforeDateDescription"));
        this.beforeDateTimeText = new DateTimeText((Composite)group, DateTimeText.Style.DATETIME, true);
        this.refresh();
    }

    public boolean saveToFilter() {
        boolean success = false;
        if (this.filter != null) {
            try {
                Date afterDate = this.afterDateTimeText.getDate();
                try {
                    Date beforeDate = this.beforeDateTimeText.getDate();
                    this.filter.setDates(afterDate, beforeDate);
                    success = true;
                }
                catch (ProblemException exception) {
                    this.beforeDateTimeText.setFocus();
                    ProblemDialog.openProblem(this.parent.getShell(), Messages.getString("JobSubmissionTimeComposite.ErrTitle"), Messages.getString("JobSubmissionTimeComposite.ErrSavingBeforeDate"), exception);
                }
            }
            catch (ProblemException exception) {
                this.afterDateTimeText.setFocus();
                ProblemDialog.openProblem(this.parent.getShell(), Messages.getString("JobSubmissionTimeComposite.ErrTitle"), Messages.getString("JobSubmissionTimeComposite.ErrSavingAfterDate"), exception);
            }
        }
        return success;
    }

    public void setFilter(IGridFilterConfiguration filterConfiguration) {
        if (filterConfiguration != null) {
            this.filter = ((JobViewFilterConfiguration)filterConfiguration).getSubmissionTimeFilter();
        }
        this.refresh();
    }

    private void refresh() {
        Date afterDate = null;
        Date beforeDate = null;
        if (this.filter != null) {
            afterDate = this.filter.getAfterDate();
            beforeDate = this.filter.getBeforeDate();
        }
        this.afterDateTimeText.setDate(afterDate);
        this.beforeDateTimeText.setDate(beforeDate);
    }

    public void setEnabled(boolean enabled) {
        this.afterDateTimeText.setEnabled(enabled);
        this.beforeDateTimeText.setEnabled(enabled);
    }
}

