/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ICertificateManager;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateContentProvider
implements ITreeContentProvider {
    private static final String NA_STRING = "N/A";
    private boolean grouped = true;
    private GroupMode groupMode = GroupMode.Organization;

    public Object[] getChildren(Object parentElement) {
        Object value;
        Object[] result = new Object[]{};
        if (parentElement instanceof Map.Entry && (value = ((Map.Entry)parentElement).getValue()) instanceof List) {
            List list = (List)value;
            result = list.toArray(new Object[list.size()]);
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof Map.Entry) {
            result = true;
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = new Object[]{};
        if (inputElement instanceof ICertificateManager) {
            List certificates = ((ICertificateManager)inputElement).getAllCertificates();
            if (!this.isGrouped()) {
                result = certificates.toArray();
            } else {
                Set<Map.Entry<String, List<ICertificateHandle>>> entrySet = this.getGroupedCertificates(certificates, this.getGroupMode());
                result = entrySet.toArray();
            }
        }
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public GroupMode getGroupMode() {
        return this.groupMode;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean b) {
        this.grouped = b;
    }

    public void setGroupMode(GroupMode mode) {
        this.groupMode = mode;
    }

    private Set<Map.Entry<String, List<ICertificateHandle>>> getGroupedCertificates(List<ICertificateHandle> certs, GroupMode m) {
        Hashtable<String, ArrayList<ICertificateHandle>> table = new Hashtable<String, ArrayList<ICertificateHandle>>();
        for (ICertificateHandle c : certs) {
            ArrayList<ICertificateHandle> list;
            String name = this.getGroupName(c, m);
            if (name == null || name.trim().length() == 0) {
                name = NA_STRING;
            }
            if ((list = (ArrayList<ICertificateHandle>)table.get(name)) == null) {
                list = new ArrayList<ICertificateHandle>();
                table.put(name, list);
            }
            list.add(c);
        }
        return table.entrySet();
    }

    private String getGroupName(ICertificateHandle h, GroupMode m) {
        String result = NA_STRING;
        if (m == GroupMode.Country) {
            result = CertificateContentProvider.getSubjectDN(h.getCertificate(), "C");
        } else if (m == GroupMode.State) {
            result = CertificateContentProvider.getSubjectDN(h.getCertificate(), "ST");
        } else if (m == GroupMode.Locality) {
            result = CertificateContentProvider.getSubjectDN(h.getCertificate(), "L");
        } else if (m == GroupMode.Organization) {
            result = CertificateContentProvider.getSubjectDN(h.getCertificate(), "O");
        } else if (m == GroupMode.OrganizationalUnit) {
            result = CertificateContentProvider.getSubjectDN(h.getCertificate(), "OU");
        } else if (m == GroupMode.Trust) {
            result = h.getTrust().toString();
        }
        return result;
    }

    static String getSubjectDN(X509Certificate c, String part) {
        String[] parts;
        String result = NA_STRING;
        String search = String.valueOf(part.toUpperCase()) + "=";
        String name = c.getSubjectX500Principal().getName();
        String[] stringArray = parts = name.split("[,/]");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.trim().toUpperCase().startsWith(search)) {
                result = s.trim().substring(search.length());
                break;
            }
            ++n2;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupMode {
        Country,
        State,
        Locality,
        Organization,
        OrganizationalUnit,
        Trust;

    }
}

