/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateLoader;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.wizards.CertificateLoaderSelectionPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CertificateChooserPage
extends WizardPage {
    protected CheckboxTableViewer viewer;
    private CertificateLoaderSelectionPage selectionPage;

    public CertificateChooserPage(CertificateLoaderSelectionPage selectionPage) {
        super("certificateChooserPage", "Choose Certificates", null);
        this.setDescription("Choose the Certificates you would like to import");
        this.selectionPage = selectionPage;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1808);
        mainComp.setLayoutData((Object)gData);
        Table table = new Table(mainComp, 2848);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gData);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = super.getText(element);
                if (element instanceof ICertificateLoader.CertificateID) {
                    result = ((ICertificateLoader.CertificateID)element).getName();
                }
                return result;
            }
        });
        Composite buttonComp = new Composite(mainComp, 0);
        buttonComp.setLayout((Layout)new GridLayout(3, false));
        gData = new GridData();
        buttonComp.setLayoutData((Object)gData);
        Button selectAllButton = new Button(buttonComp, 8);
        selectAllButton.setText("&Select All");
        gData = new GridData();
        selectAllButton.setLayoutData((Object)gData);
        Button deselectAllButton = new Button(buttonComp, 8);
        deselectAllButton.setText("&Deselect All");
        gData = new GridData();
        deselectAllButton.setLayoutData((Object)gData);
        Button invertButton = new Button(buttonComp, 8);
        invertButton.setText("&Invert Selection");
        gData = new GridData();
        invertButton.setLayoutData((Object)gData);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateChooserPage.this.selectAll();
            }
        });
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateChooserPage.this.deselectAll();
            }
        });
        invertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateChooserPage.this.invertSelection();
            }
        });
        this.setControl((Control)mainComp);
    }

    public ICertificateLoader.CertificateID[] getSelectedCertificates() {
        ICertificateLoader.CertificateID[] result = null;
        Object[] checkedElements = this.viewer.getCheckedElements();
        if (checkedElements != null) {
            result = new ICertificateLoader.CertificateID[checkedElements.length];
            int i = 0;
            while (i < checkedElements.length) {
                result[i] = (ICertificateLoader.CertificateID)checkedElements[i];
                ++i;
            }
        }
        return result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadCertificates();
        }
    }

    protected void selectAll() {
        this.viewer.setAllChecked(true);
    }

    protected void deselectAll() {
        this.viewer.setAllChecked(false);
    }

    protected void invertSelection() {
        ICertificateLoader.CertificateID[] elements;
        ICertificateLoader.CertificateID[] certificateIDArray = elements = (ICertificateLoader.CertificateID[])this.viewer.getInput();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ICertificateLoader.CertificateID element;
            boolean state = this.viewer.getChecked((Object)(element = certificateIDArray[n2]));
            this.viewer.setChecked((Object)element, !state);
            ++n2;
        }
    }

    private void loadCertificates() {
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        this.viewer.setInput(null);
        final ICertificateLoader loader = this.selectionPage.getSelectedLoader();
        final URI uri = this.selectionPage.getURI();
        this.setErrorMessage(this.selectionPage.getErrorMessage());
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final ICertificateLoader.CertificateID[] certificates = loader.listAvailableCertificates(uri, monitor);
                        CertificateChooserPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                (this).CertificateChooserPage.this.viewer.setInput((Object)certificates);
                                if (certificates.length == 0) {
                                    CertificateChooserPage.this.setMessage("No certificates found at the specified location", 2);
                                }
                            }
                        });
                    }
                    catch (ProblemException pExc) {
                        throw new InvocationTargetException(pExc);
                    }
                }
            });
        }
        catch (InvocationTargetException itExc) {
            Throwable exc = itExc.getCause() == null ? itExc : itExc.getCause();
            this.setErrorMessage("Unable to load certificates: " + exc.getLocalizedMessage());
            ProblemDialog.openProblem(this.getShell(), "Certificate load failed", "Unable to load certificates", exc);
        }
        catch (InterruptedException intExc) {
            this.setErrorMessage("Unable to load certificates: " + intExc.getLocalizedMessage());
        }
    }
}

