/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateLoader;
import eu.geclipse.core.security.ICertificateManager;
import eu.geclipse.core.security.Security;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.wizards.CertificateChooserPage;
import eu.geclipse.ui.internal.wizards.CertificateLoaderSelectionPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public class CertificateImportWizard
extends Wizard {
    private CertificateLoaderSelectionPage loaderPage;
    private CertificateChooserPage chooserPage;

    public CertificateImportWizard() {
        this.setNeedsProgressMonitor(true);
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/cacert_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public void addPages() {
        this.loaderPage = new CertificateLoaderSelectionPage();
        this.addPage((IWizardPage)this.loaderPage);
        this.chooserPage = new CertificateChooserPage(this.loaderPage);
        this.addPage((IWizardPage)this.chooserPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.chooserPage && this.chooserPage.isPageComplete();
    }

    public String getWindowTitle() {
        return "Certificate import";
    }

    public boolean performFinish() {
        boolean result = true;
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        currentPage.setErrorMessage(null);
        final ICertificateLoader loader = this.loaderPage.getSelectedLoader();
        final ICertificateLoader.CertificateID[] certificates = this.chooserPage.getSelectedCertificates();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Importing certificates", certificates.length);
                    ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                    try {
                        try {
                            ICertificateLoader.CertificateID[] certificateIDArray = certificates;
                            int n = certificates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICertificateLoader.CertificateID certID = certificateIDArray[n2];
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                                X509Certificate certificate = loader.fetchCertificate(certID, (IProgressMonitor)subMonitor);
                                if (certificate != null) {
                                    certList.add(certificate);
                                }
                                ++n2;
                            }
                        }
                        catch (ProblemException pExc) {
                            throw new InvocationTargetException(pExc);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    if (!certList.isEmpty()) {
                        X509Certificate[] certArray = certList.toArray(new X509Certificate[certList.size()]);
                        try {
                            Security.getCertificateManager().addCertificates(certArray, ICertificateManager.CertTrust.AlwaysTrusted);
                        }
                        catch (ProblemException pExc) {
                            throw new InvocationTargetException(pExc);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException itExc) {
            Throwable cause = itExc.getCause() == null ? itExc : itExc.getCause();
            ProblemDialog.openProblem(this.getShell(), "Certifcate import failed", "A problem occured while the certificates were imported. At least parts of the certificates may not have been imported properly.", cause);
            currentPage.setErrorMessage(cause.getLocalizedMessage());
            result = false;
        }
        catch (InterruptedException intExc) {
            currentPage.setErrorMessage(intExc.getLocalizedMessage());
            result = false;
        }
        return result;
    }
}

