/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.model.IVoLoader;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.wizards.Messages;
import eu.geclipse.ui.internal.wizards.VoImportLocationChooserPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class VoChooserPage
extends WizardPage {
    protected CheckboxTableViewer viewer;
    protected Text filterText;
    protected VoFilter voFilter;
    protected List<Object> selection = new ArrayList<Object>();
    private VoImportLocationChooserPage locationChooserPage;

    public VoChooserPage(VoImportLocationChooserPage locationChooserPage) {
        super("voChooserPage", Messages.getString("VoChooserPage.title"), null);
        this.setDescription(Messages.getString("VoChooserPage.description"));
        this.locationChooserPage = locationChooserPage;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1808);
        mainComp.setLayoutData((Object)gData);
        this.filterText = new Text(mainComp, 2176);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.setText(Messages.getString("VoChooserPage.initial_filter_text"));
        this.filterText.selectAll();
        Table table = new Table(mainComp, 2848);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gData);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.voFilter = new VoFilter();
        this.viewer.addFilter((ViewerFilter)this.voFilter);
        Composite buttonComp = new Composite(mainComp, 0);
        buttonComp.setLayout((Layout)new GridLayout(3, false));
        gData = new GridData();
        buttonComp.setLayoutData((Object)gData);
        Button selectAllButton = new Button(buttonComp, 8);
        selectAllButton.setText(Messages.getString("VoChooserPage.select_all_button"));
        gData = new GridData();
        selectAllButton.setLayoutData((Object)gData);
        Button deselectAllButton = new Button(buttonComp, 8);
        deselectAllButton.setText(Messages.getString("VoChooserPage.deselect_all_button"));
        gData = new GridData();
        deselectAllButton.setLayoutData((Object)gData);
        Button invertButton = new Button(buttonComp, 8);
        invertButton.setText(Messages.getString("VoChooserPage.invert_selection_button"));
        gData = new GridData();
        invertButton.setLayoutData((Object)gData);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                VoChooserPage.this.handleCheckStateChanged(event);
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VoChooserPage.this.voFilter.setFilterText(VoChooserPage.this.filterText.getText());
                VoChooserPage.this.viewer.refresh();
                VoChooserPage.this.viewer.setCheckedElements(VoChooserPage.this.selection.toArray(new Object[VoChooserPage.this.selection.size()]));
            }
        });
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoChooserPage.this.selectAll();
            }
        });
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoChooserPage.this.deselectAll();
            }
        });
        invertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoChooserPage.this.invertSelection();
            }
        });
        this.setControl((Control)mainComp);
    }

    public String[] getSelectedVos() {
        String[] result = null;
        result = new String[this.selection.size()];
        int i = 0;
        while (i < this.selection.size()) {
            result[i] = (String)this.selection.get(i);
            ++i;
        }
        return result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadVoList();
            if (!this.filterText.isDisposed()) {
                this.filterText.setFocus();
            }
        }
    }

    protected void handleCheckStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (event.getChecked()) {
            this.addToSelection(new Object[]{element});
        } else if (!event.getChecked()) {
            this.removeFromSelection(new Object[]{element});
        }
    }

    protected void selectAll() {
        this.viewer.setAllChecked(true);
        this.addToSelection(this.viewer.getCheckedElements());
    }

    protected void deselectAll() {
        this.removeFromSelection(this.viewer.getCheckedElements());
        this.viewer.setAllChecked(false);
    }

    protected void invertSelection() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.viewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String element;
            TableItem item = tableItemArray[n2];
            boolean state = this.viewer.getChecked((Object)(element = (String)item.getData()));
            this.viewer.setChecked((Object)element, !state);
            if (state) {
                this.removeFromSelection(new Object[]{element});
            } else {
                this.addToSelection(new Object[]{element});
            }
            ++n2;
        }
    }

    private void addToSelection(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.selection.contains(element)) {
                this.selection.add(element);
            }
            ++n2;
        }
    }

    private void removeFromSelection(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.selection.contains(element)) {
                this.selection.remove(element);
            }
            ++n2;
        }
    }

    private void loadVoList() {
        final IVoLoader loader = this.locationChooserPage.getLoader();
        final URI uri = this.locationChooserPage.getSelectedLocation();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        String[] voArray = loader.getVoList(uri, monitor);
                        ArrayList<String> voList = new ArrayList<String>();
                        String[] stringArray = voArray;
                        int n = voArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String vo = stringArray[n2];
                            if (!voList.contains(vo)) {
                                voList.add(vo);
                            }
                            ++n2;
                        }
                        VoChooserPage.this.viewer.setInput(voList);
                    }
                    catch (ProblemException pExc) {
                        throw new InvocationTargetException(pExc);
                    }
                }
            });
        }
        catch (InvocationTargetException itExc) {
            Throwable cause = itExc.getCause();
            ProblemDialog.openProblem(this.getShell(), Messages.getString("VoChooserPage.import_failed_title"), Messages.getString("VoChooserPage.import_failed_error"), cause);
            this.setErrorMessage(cause.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class VoFilter
    extends ViewerFilter {
        private String filterText;

        public void setFilterText(String text) {
            this.filterText = text;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.filterText == null || this.filterText.trim().length() == 0 || ((String)element).toLowerCase().startsWith(this.filterText.toLowerCase());
        }
    }
}

