/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoSource
extends AbstractPropertySource<IFileInfo> {
    private static List<IProperty<IFileInfo>> staticProperties;
    private static List<Attribute> attributes;

    public FileInfoSource(IFileInfo sourceObject) {
        super(sourceObject);
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return FileInfoSource.class;
    }

    @Override
    protected List<IProperty<IFileInfo>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = FileInfoSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<IFileInfo>> createProperties() {
        ArrayList<IProperty<IFileInfo>> propertiesList = new ArrayList<IProperty<IFileInfo>>();
        propertiesList.add(FileInfoSource.createName());
        propertiesList.add(FileInfoSource.createLength());
        propertiesList.add(FileInfoSource.createLastModified());
        propertiesList.add(FileInfoSource.createAttributes());
        propertiesList.add(FileInfoSource.createLinkTarget());
        return propertiesList;
    }

    protected static List<Attribute> getAttributes() {
        if (attributes == null) {
            attributes = Arrays.asList(new Attribute(4, Messages.getString("FileInfoSource.attrExecutable")), new Attribute(32, Messages.getString("FileInfoSource.attrLink")), new Attribute(16, Messages.getString("FileInfoSource.attrHidden")), new Attribute(8, Messages.getString("FileInfoSource.attrArchive")), new Attribute(2, Messages.getString("FileInfoSource.attrReadOnly")));
        }
        return attributes;
    }

    private static IProperty<IFileInfo> createName() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propName"), null){

            @Override
            public Object getValue(IFileInfo fileInfo) {
                return fileInfo.getName();
            }
        };
    }

    private static IProperty<IFileInfo> createLength() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propLength"), null, false){

            @Override
            public Object getValue(IFileInfo fileInfo) {
                String valueString = null;
                if (!fileInfo.isDirectory()) {
                    valueString = this.getBytesFormattedString(fileInfo.getLength());
                }
                return valueString;
            }
        };
    }

    private static IProperty<IFileInfo> createLastModified() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propLastModified"), null, false){

            @Override
            public Object getValue(IFileInfo fileInfo) {
                String valueString = null;
                if (fileInfo.getLastModified() != 0L) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(fileInfo.getLastModified());
                    valueString = DateFormat.getDateTimeInstance().format(calendar.getTime());
                }
                return valueString;
            }
        };
    }

    private static IProperty<IFileInfo> createAttributes() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propAttributes"), null, false){

            @Override
            public Object getValue(IFileInfo fileInfo) {
                StringBuilder valueString = new StringBuilder();
                for (Attribute attribute : FileInfoSource.getAttributes()) {
                    if (!fileInfo.getAttribute(attribute.efsId)) continue;
                    if (valueString.length() > 0) {
                        valueString.append(", ");
                    }
                    valueString.append(attribute.name);
                }
                return valueString.length() > 0 ? valueString : null;
            }
        };
    }

    private static IProperty<IFileInfo> createLinkTarget() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propLinkTarget"), null, false){

            @Override
            public Object getValue(IFileInfo fileInfo) {
                return fileInfo.getStringAttribute(64);
            }
        };
    }

    protected static class Attribute {
        final int efsId;
        final String name;

        Attribute(int id, String name) {
            this.efsId = id;
            this.name = name;
        }
    }
}

