/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIPropertySource
extends AbstractPropertySource<URI> {
    private static List<IProperty<URI>> staticProperties;

    public URIPropertySource(URI uri) {
        super(URIPropertySource.getRealUri(uri));
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return URIPropertySource.class;
    }

    @Override
    protected List<IProperty<URI>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = URIPropertySource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<URI>> createProperties() {
        ArrayList<IProperty<URI>> propertiesList = new ArrayList<IProperty<URI>>(4);
        propertiesList.add(URIPropertySource.createHost());
        propertiesList.add(URIPropertySource.createPath());
        propertiesList.add(URIPropertySource.createPort());
        propertiesList.add(URIPropertySource.createScheme());
        return propertiesList;
    }

    private static IProperty<URI> createHost() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyHost"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uri) {
                return uri.getHost();
            }
        };
    }

    private static IProperty<URI> createPath() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyPath"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uri) {
                return uri.getPath();
            }
        };
    }

    private static IProperty<URI> createPort() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyPort"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uri) {
                String portString = null;
                if (uri.getPort() != -1) {
                    portString = String.valueOf(uri.getPort());
                }
                return portString;
            }
        };
    }

    private static IProperty<URI> createScheme() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyScheme"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uri) {
                String portString = null;
                if (uri.getPort() != -1) {
                    portString = String.valueOf(uri.getScheme());
                }
                return portString;
            }
        };
    }

    static URI getRealUri(URI uri) {
        URI slaveUri = new GEclipseURI(uri).toSlaveURI();
        return slaveUri != null ? slaveUri : uri;
    }
}

