/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.accesscontrol.ActorType;
import eu.geclipse.core.accesscontrol.IACLEntry;
import eu.geclipse.ui.internal.ImageLoader;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ACLEntryLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int COL_POLICY = 0;
    private static final int COL_CAPABILITY = 1;
    private static final int COL_ACTOR_TYPE = 2;
    private static final int COL_ACTOR_ID = 3;
    private static final int COL_ACTOR_CA = 4;

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        if (element instanceof IACLEntry) {
            IACLEntry entry = (IACLEntry)element;
            switch (columnIndex) {
                case 0: {
                    result = entry.getPolicy().getName();
                    break;
                }
                case 1: {
                    result = entry.getCapability().getName();
                    break;
                }
                case 2: {
                    result = entry.getActor().getActorType().getName();
                    break;
                }
                case 3: {
                    result = entry.getActor().getID();
                    break;
                }
                case 4: {
                    result = entry.getActor().getCA();
                    break;
                }
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image img = null;
        if (element instanceof IACLEntry) {
            IACLEntry entry = (IACLEntry)element;
            switch (columnIndex) {
                case 0: {
                    short pType = entry.getPolicy().getType();
                    img = this.getPolicyImage(pType);
                    break;
                }
                case 2: {
                    ActorType type = entry.getActor().getActorType();
                    img = this.getActorTypeImage(type);
                    break;
                }
            }
        }
        return img;
    }

    private Image getPolicyImage(short pType) {
        Image img = null;
        if (pType == 1) {
            img = ImageLoader.get("obj16/acl_allow_tbl.gif");
        } else if (pType == -1) {
            img = ImageLoader.get("obj16/acl_deny_tbl.gif");
        }
        return img;
    }

    private Image getActorTypeImage(ActorType type) {
        Image img = null;
        if (type == ActorType.ANYBODY || type == ActorType.CA_ANY_DN_ANY) {
            img = ImageLoader.get("obj16/acl_anyone_tbl.gif");
        } else if (type == ActorType.GROUP_NAME || type == ActorType.GROUP_PATTERN || type == ActorType.USER_PATTERN) {
            img = ImageLoader.get("obj16/acl_group_tbl.gif");
        } else if (type == ActorType.CA_NAME_DN_ANY || type == ActorType.CA_NAME_DN_PATTERN) {
            img = ImageLoader.get("obj16/acl_ca_tbl.gif");
        } else if (type == ActorType.CA_NAME_DN_NAME || type == ActorType.USER_NAME || type == ActorType.USER_EMAIL) {
            img = ImageLoader.get("obj16/acl_user_tbl.gif");
        } else if (type == ActorType.SAML_ATTRIBUTE) {
            img = ImageLoader.get("obj16/acl_saml_tbl.gif");
        }
        return img;
    }
}

