/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.util.MasterMonitor;
import eu.geclipse.ui.dialogs.ProblemDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;

public class FetchChildrenJob
extends Job {
    private IGridContainer container;
    private IProgressMonitor externalMonitor;
    private Shell shell;

    public FetchChildrenJob(IGridContainer container, Shell shell) {
        super("Fetching Children of " + container.getName());
        this.container = container;
        this.shell = shell;
    }

    public void setExternalMonitor(IProgressMonitor monitor) {
        this.externalMonitor = monitor;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        MasterMonitor mMonitor = new MasterMonitor(monitor, this.externalMonitor);
        try {
            try {
                this.container.setDirty();
                this.container.getChildren((IProgressMonitor)mMonitor);
                result = Status.OK_STATUS;
            }
            catch (ProblemException pExc) {
                ProblemDialog.openProblem(this.shell, "Fetch Error", "Error while fetching children of " + this.container.getName(), pExc);
                mMonitor.done();
            }
        }
        finally {
            mMonitor.done();
        }
        return result;
    }
}

