/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class FileStoreLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String COLUMN_TYPE_NAME = "NAME";
    public static final String COLUMN_TYPE_SIZE = "SIZE";
    public static final String COLUMN_TYPE_MOD_DATE = "MOD_DATE";
    protected static final String EMPTY_STRING = "";
    protected static final String NA_STRING = "N/A";
    private static final String[] prefixes = new String[]{"", "k", "M", "G", "T", "P", "E"};
    private static final String FILE_SIZE_UNIT = "B";
    private static final String FILE_SIZE_FORMAT = "0.#";
    private static Hashtable<String, Image> images;
    private DateFormat dateFormat = new SimpleDateFormat();
    private DecimalFormat sizeFormat = new DecimalFormat("0.#");
    private Hashtable<Integer, String> columnMap;

    public void addColumn(int index, String type) {
        if (this.columnMap == null) {
            this.columnMap = new Hashtable();
        }
        this.columnMap.put(index, type);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IFileStore adapter;
        Image result = null;
        if (element instanceof IFileStore) {
            result = this.getColumnImage((IFileStore)element, columnIndex);
        } else if (element instanceof IAdaptable && (adapter = (IFileStore)((IAdaptable)element).getAdapter(IFileStore.class)) != null) {
            result = this.getColumnImage(adapter, columnIndex);
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        IFileStore adapter;
        String result = null;
        if (element instanceof IFileStore) {
            result = this.getColumnText((IFileStore)element, columnIndex);
        } else if (element instanceof IAdaptable && (adapter = (IFileStore)((IAdaptable)element).getAdapter(IFileStore.class)) != null) {
            result = this.getColumnText(adapter, columnIndex);
        }
        return result;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    protected Image getColumnImage(IFileStore fileStore, int columnIndex) {
        Image result = null;
        if (columnIndex == 0) {
            IFileInfo info = fileStore.fetchInfo();
            result = info.isDirectory() ? FileStoreLabelProvider.getFolderImage() : FileStoreLabelProvider.getFileImage();
        }
        return result;
    }

    protected String getColumnText(IFileStore fileStore, int columnIndex) {
        String result = EMPTY_STRING;
        String type = this.getColumnType(columnIndex);
        if (COLUMN_TYPE_NAME.equals(type)) {
            result = this.getName(fileStore);
        } else if (COLUMN_TYPE_SIZE.equals(type)) {
            result = this.getSize(fileStore);
        } else if (COLUMN_TYPE_MOD_DATE.equals(type)) {
            result = this.getModificationDate(fileStore);
        }
        return result;
    }

    protected String getColumnType(int columnIndex) {
        String result = null;
        if (this.columnMap != null) {
            result = this.columnMap.get(columnIndex);
        }
        return result;
    }

    protected String convertTimeToString(long time) {
        String result = NA_STRING;
        if (time != 0L) {
            Date date = new Date(time);
            result = this.dateFormat.format(date);
        }
        return result;
    }

    protected String convertSizeToString(long size) {
        String result = NA_STRING;
        if (size == 0L) {
            result = "0 B";
        } else if (size > 0L) {
            double mag = Math.floor(Math.log(size) / Math.log(1024.0));
            if (mag >= (double)prefixes.length) {
                mag = prefixes.length - 1;
            }
            double ref = Math.pow(1024.0, mag);
            double value = (double)size / ref;
            result = String.valueOf(this.sizeFormat.format(value)) + " " + prefixes[(int)mag] + FILE_SIZE_UNIT;
        }
        return result;
    }

    protected String getModificationDate(IFileStore fileStore) {
        String result = NA_STRING;
        if (fileStore != null) {
            result = this.convertTimeToString(fileStore.fetchInfo().getLastModified());
        }
        return result;
    }

    protected String getName(IFileStore fileStore) {
        return fileStore.getName();
    }

    protected String getSize(IFileStore fileStore) {
        String result = NA_STRING;
        if (fileStore != null) {
            result = fileStore.fetchInfo().isDirectory() ? EMPTY_STRING : this.convertSizeToString(fileStore.fetchInfo().getLength());
        }
        return result;
    }

    protected static Image getFileImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    protected static Image getFolderImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    protected static Image getImage(String path) {
        Image result = null;
        if (images == null) {
            images = new Hashtable();
        } else {
            result = images.get(path);
        }
        if (result == null) {
            result = FileStoreLabelProvider.loadImage(path);
            images.put(path, result);
        }
        return result;
    }

    protected static Image loadImage(String path) {
        URL url = Activator.getDefault().getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }
}

