/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IWrappedElement;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.info.model.GridGlueService;
import eu.geclipse.ui.providers.FileStoreLabelProvider;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NewGridModelLabelProvider
extends FileStoreLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String IMG_COMPUTING = "icons/obj16/computing_obj.gif";
    private static final String IMG_ERROR_MARKER = "icons/obj16/ihigh_obj.gif";
    private static final String IMG_INFO_MARKER = "icons/obj16/info_obj.gif";
    private static final String IMG_JOB = "icons/obj16/job_file_obj.gif";
    private static final String IMG_JOB_DESCRIPTION = "icons/obj16/jsdl_file_obj.gif";
    private static final String IMG_SERVICE = "icons/obj16/service_obj.gif";
    private static final String IMG_SERVICE_UNSUPPORTED = "icons/obj16/service_unsupported_obj.gif";
    private static final String IMG_STORAGE = "icons/obj16/storage_obj.gif";
    private static final String IMG_VIRTUAL_FILE = "icons/obj16/virtual_file_obj.gif";
    private static final String IMG_VIRTUAL_FOLDER = "icons/obj16/virtual_folder_obj.gif";
    private static final String IMG_VO = "icons/obj16/vo_obj.gif";
    private static ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        IGridElement adapter;
        Image result = null;
        if (element instanceof IGridElement) {
            result = this.getColumnImage((IGridElement)element, columnIndex);
        } else if (element instanceof IAdaptable && (adapter = (IGridElement)((IAdaptable)element).getAdapter(IGridElement.class)) != null) {
            this.getColumnImage(adapter, columnIndex);
        }
        if (result == null) {
            result = super.getColumnImage(element, columnIndex);
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        IGridElement adapter;
        String result = null;
        if (element instanceof IGridElement) {
            result = this.getColumnText((IGridElement)element, columnIndex);
        } else if (element instanceof IAdaptable && (adapter = (IGridElement)((IAdaptable)element).getAdapter(IGridElement.class)) != null) {
            this.getColumnText(adapter, columnIndex);
        }
        if (result == null) {
            result = super.getColumnText(element, columnIndex);
        }
        return result;
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text == null) {
            text = "";
        }
        return new StyledString(text);
    }

    protected Image getColumnImage(IGridElement element, int columnIndex) {
        Image result = null;
        if (columnIndex == 0) {
            result = element.isVirtual() ? NewGridModelLabelProvider.getVirtualElementImage(element) : NewGridModelLabelProvider.getRealElementImage(element);
        }
        return result;
    }

    protected String getColumnText(IGridElement element, int columnIndex) {
        String result = "";
        String type = this.getColumnType(columnIndex);
        if ("NAME".equals(type)) {
            result = this.getName(element);
        } else if ("SIZE".equals(type)) {
            result = this.getSize(element);
        } else if ("MOD_DATE".equals(type)) {
            result = this.getModificationDate(element);
        }
        return result;
    }

    private String getName(IGridElement element) {
        return element.getName();
    }

    private String getSize(IGridElement element) {
        String result = "N/A";
        IFileStore fileStore = null;
        if (element instanceof IGridConnectionElement) {
            try {
                fileStore = ((IGridConnectionElement)element).getConnectionFileStore();
            }
            catch (CoreException coreException) {}
        } else {
            fileStore = element.getFileStore();
        }
        if (fileStore != null) {
            result = this.getSize(fileStore);
        }
        return result;
    }

    private String getModificationDate(IGridElement element) {
        String result = "N/A";
        IFileStore fileStore = null;
        if (element instanceof IGridConnectionElement) {
            try {
                fileStore = ((IGridConnectionElement)element).getConnectionFileStore();
            }
            catch (CoreException coreException) {}
        } else {
            fileStore = element.getFileStore();
        }
        if (fileStore != null) {
            result = this.getModificationDate(fileStore);
        }
        return result;
    }

    private static Image getRealElementImage(IGridElement element) {
        Image result = null;
        if (element instanceof IGridJob) {
            result = NewGridModelLabelProvider.getImage(IMG_JOB);
        } else if (element instanceof IGridJobDescription) {
            result = NewGridModelLabelProvider.getImage(IMG_JOB_DESCRIPTION);
        } else {
            IResource resource = element.getResource();
            result = workbenchLabelProvider.getImage((Object)resource);
        }
        return result;
    }

    private static Image getVirtualElementImage(IGridElement element) {
        Image result = null;
        if (element instanceof IVirtualOrganization) {
            result = NewGridModelLabelProvider.getImage(IMG_VO);
        } else if (element instanceof IGridComputing) {
            result = NewGridModelLabelProvider.getImage(IMG_COMPUTING);
        } else if (element instanceof IGridStorage) {
            result = NewGridModelLabelProvider.getImage(IMG_STORAGE);
        } else if (element instanceof IGridService) {
            boolean isSupported;
            IGridElement wrappedElement;
            result = element instanceof IWrappedElement ? ((wrappedElement = ((IWrappedElement)element).getWrappedElement()) instanceof GridGlueService ? ((isSupported = ((GridGlueService)wrappedElement).getGlueService().isSupported()) ? NewGridModelLabelProvider.getImage(IMG_SERVICE) : NewGridModelLabelProvider.getImage(IMG_SERVICE_UNSUPPORTED)) : NewGridModelLabelProvider.getImage(IMG_SERVICE)) : NewGridModelLabelProvider.getImage(IMG_SERVICE);
        } else if (element instanceof ContainerMarker) {
            ContainerMarker.MarkerType type = ((ContainerMarker)element).getType();
            if (type == ContainerMarker.MarkerType.INFO) {
                result = NewGridModelLabelProvider.getImage(IMG_INFO_MARKER);
            } else if (type == ContainerMarker.MarkerType.ERROR) {
                result = NewGridModelLabelProvider.getImage(IMG_ERROR_MARKER);
            }
        } else {
            result = element instanceof IGridContainer ? NewGridModelLabelProvider.getImage(IMG_VIRTUAL_FOLDER) : NewGridModelLabelProvider.getImage(IMG_VIRTUAL_FILE);
        }
        return result;
    }
}

